/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.domain.util;

import java.util.Objects;
import javax.annotation.Nonnull;

public final class SystemUtils {
    private static final String JVM_ARCH_PROPERTY = "os.arch";
    private static final String OS_NAME_PROPERTY = "os.name";

    private SystemUtils() {
    }

    @Nonnull
    public static String getSystemJvmArch() {
        return SystemUtils.getPropertyAndAssertNotNull(JVM_ARCH_PROPERTY);
    }

    @Nonnull
    public static String getSystemOsName() {
        return SystemUtils.getPropertyAndAssertNotNull(OS_NAME_PROPERTY);
    }

    @Nonnull
    private static String getPropertyAndAssertNotNull(@Nonnull String property) {
        return Objects.requireNonNull(System.getProperty(property), "Unexpected <null> value when reading system property: " + property);
    }
}

