/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.domain.util;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;

public final class PathUtils {
    private static final Set<String> GZIP_EXTENSIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(".gz", ".gzip")));

    private PathUtils() {
    }

    @Nonnull
    public static Optional<String> getExtension(@Nonnull Path filePath) {
        return Optional.ofNullable(filePath.getFileName()).map(Path::toString).flatMap(PathUtils::getExtension);
    }

    @Nonnull
    public static Optional<String> getExtension(@Nonnull String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index == -1) {
            return Optional.empty();
        }
        return Optional.of(fileName.substring(fileName.lastIndexOf(46)));
    }

    @Nonnull
    public static String removeExtension(@Nonnull Path filePath) {
        Path leafFilePath = filePath.getFileName();
        if (leafFilePath == null) {
            return filePath.toString();
        }
        String leafFilePathAsString = leafFilePath.toString();
        int index = leafFilePathAsString.lastIndexOf(46);
        if (index == -1) {
            return leafFilePathAsString;
        }
        return leafFilePathAsString.substring(0, index);
    }

    public static boolean isGzipExtension(@Nonnull String extension) {
        return GZIP_EXTENSIONS.contains(extension);
    }
}

