/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.domain.usecase;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import javax.annotation.Nonnull;
import org.siouan.frontendgradleplugin.domain.exception.InvalidNodeDistributionException;
import org.siouan.frontendgradleplugin.domain.exception.NodeDistributionShasumNotFoundException;
import org.siouan.frontendgradleplugin.domain.model.DistributionValidator;
import org.siouan.frontendgradleplugin.domain.model.DistributionValidatorSettings;
import org.siouan.frontendgradleplugin.domain.model.DownloadSettings;
import org.siouan.frontendgradleplugin.domain.model.Logger;
import org.siouan.frontendgradleplugin.domain.provider.FileManager;
import org.siouan.frontendgradleplugin.domain.usecase.DownloadResource;
import org.siouan.frontendgradleplugin.domain.usecase.HashFile;
import org.siouan.frontendgradleplugin.domain.usecase.ReadNodeDistributionShasum;

public class ValidateNodeDistribution
implements DistributionValidator {
    public static final String SHASUMS_FILENAME = "SHASUMS256.txt";
    private final FileManager fileManager;
    private final DownloadResource downloadResource;
    private final ReadNodeDistributionShasum readNodeDistributionShasum;
    private final HashFile hashFile;
    private final Logger logger;

    public ValidateNodeDistribution(FileManager fileManager, DownloadResource downloadResource, ReadNodeDistributionShasum readNodeDistributionShasum, HashFile hashFile, Logger logger) {
        this.fileManager = fileManager;
        this.downloadResource = downloadResource;
        this.readNodeDistributionShasum = readNodeDistributionShasum;
        this.hashFile = hashFile;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(@Nonnull DistributionValidatorSettings distributionValidatorSettings) throws InvalidNodeDistributionException, IOException, NodeDistributionShasumNotFoundException {
        String expectedShasum;
        Path shasumsFilePath = distributionValidatorSettings.getTemporaryDirectoryPath().resolve(SHASUMS_FILENAME);
        try {
            URL shasumsFileUrl = new URL(distributionValidatorSettings.getDistributionUrl(), SHASUMS_FILENAME);
            this.logger.debug("Downloading shasums at '{}'", shasumsFileUrl);
            this.downloadResource.execute(new DownloadSettings(shasumsFileUrl, distributionValidatorSettings.getDistributionServerCredentials(), distributionValidatorSettings.getProxySettings(), distributionValidatorSettings.getTemporaryDirectoryPath(), shasumsFilePath));
            this.logger.info("Verifying distribution integrity", new Object[0]);
            String distributionFileName = distributionValidatorSettings.getDistributionFilePath().getFileName().toString();
            expectedShasum = this.readNodeDistributionShasum.execute(shasumsFilePath, distributionFileName).orElseThrow(() -> new NodeDistributionShasumNotFoundException(distributionFileName));
        }
        finally {
            this.fileManager.deleteIfExists(shasumsFilePath);
        }
        if (!this.hashFile.execute(distributionValidatorSettings.getDistributionFilePath()).equals(expectedShasum)) {
            throw new InvalidNodeDistributionException();
        }
    }
}

