/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.domain.usecase;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.siouan.frontendgradleplugin.domain.exception.DistributionValidatorException;
import org.siouan.frontendgradleplugin.domain.exception.InvalidDistributionUrlException;
import org.siouan.frontendgradleplugin.domain.exception.UnsupportedDistributionIdException;
import org.siouan.frontendgradleplugin.domain.exception.UnsupportedPlatformException;
import org.siouan.frontendgradleplugin.domain.model.DistributionDefinition;
import org.siouan.frontendgradleplugin.domain.model.DistributionUrlResolver;
import org.siouan.frontendgradleplugin.domain.model.DistributionValidator;
import org.siouan.frontendgradleplugin.domain.model.DistributionValidatorSettings;
import org.siouan.frontendgradleplugin.domain.model.DownloadSettings;
import org.siouan.frontendgradleplugin.domain.model.GetDistributionSettings;
import org.siouan.frontendgradleplugin.domain.model.Logger;
import org.siouan.frontendgradleplugin.domain.usecase.DownloadResource;
import org.siouan.frontendgradleplugin.domain.usecase.GetDistributionUrlResolver;
import org.siouan.frontendgradleplugin.domain.usecase.GetDistributionValidator;

public class GetDistribution {
    private static final Pattern URL_FILENAME_PATTERN = Pattern.compile("^.*/([^/]+)/*$");
    private final GetDistributionUrlResolver getDistributionUrlResolver;
    private final DownloadResource downloadResource;
    private final GetDistributionValidator getDistributionValidator;
    private final Logger logger;

    public GetDistribution(GetDistributionUrlResolver getDistributionUrlResolver, DownloadResource downloadResource, GetDistributionValidator getDistributionValidator, Logger logger) {
        this.getDistributionUrlResolver = getDistributionUrlResolver;
        this.downloadResource = downloadResource;
        this.getDistributionValidator = getDistributionValidator;
        this.logger = logger;
    }

    @Nonnull
    public Path execute(@Nonnull GetDistributionSettings getDistributionSettings) throws UnsupportedDistributionIdException, UnsupportedPlatformException, InvalidDistributionUrlException, DistributionValidatorException, IOException {
        DistributionUrlResolver distributionUrlResolver = this.getDistributionUrlResolver.execute(getDistributionSettings.getDistributionId()).orElseThrow(() -> new UnsupportedDistributionIdException(getDistributionSettings.getDistributionId()));
        DistributionDefinition distributionDefinition = new DistributionDefinition(getDistributionSettings.getPlatform(), getDistributionSettings.getVersion(), getDistributionSettings.getDistributionUrlRoot(), getDistributionSettings.getDistributionUrlPathPattern());
        URL distributionUrl = distributionUrlResolver.execute(distributionDefinition);
        this.logger.info("Downloading distribution at '{}' (proxy: {})", distributionUrl, getDistributionSettings.getProxySettings().getProxy());
        Path distributionFilePath = getDistributionSettings.getTemporaryDirectoryPath().resolve(this.resolveDistributionFileName(distributionUrl));
        this.downloadResource.execute(new DownloadSettings(distributionUrl, getDistributionSettings.getDistributionServerCredentials(), getDistributionSettings.getProxySettings(), getDistributionSettings.getTemporaryDirectoryPath(), distributionFilePath));
        Optional<DistributionValidator> distributionValidator = this.getDistributionValidator.execute(getDistributionSettings.getDistributionId());
        if (distributionValidator.isPresent()) {
            DistributionValidatorSettings distributionValidatorSettings = new DistributionValidatorSettings(getDistributionSettings.getTemporaryDirectoryPath(), distributionUrl, getDistributionSettings.getDistributionServerCredentials(), getDistributionSettings.getProxySettings(), distributionFilePath);
            distributionValidator.get().execute(distributionValidatorSettings);
        }
        return distributionFilePath;
    }

    @Nonnull
    private String resolveDistributionFileName(@Nonnull URL distributionUrl) throws InvalidDistributionUrlException {
        String distributionUrlPath = distributionUrl.getPath();
        Matcher fileNameMatcher = URL_FILENAME_PATTERN.matcher(distributionUrlPath);
        if (!fileNameMatcher.matches()) {
            throw new InvalidDistributionUrlException(distributionUrl);
        }
        return fileNameMatcher.group(1);
    }
}

