/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.domain.usecase;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import javax.annotation.Nonnull;
import org.siouan.frontendgradleplugin.domain.model.Credentials;
import org.siouan.frontendgradleplugin.domain.model.DownloadSettings;
import org.siouan.frontendgradleplugin.domain.model.Logger;
import org.siouan.frontendgradleplugin.domain.model.ProxySettings;
import org.siouan.frontendgradleplugin.domain.provider.ChannelProvider;
import org.siouan.frontendgradleplugin.domain.provider.FileManager;
import org.siouan.frontendgradleplugin.domain.provider.URLConnectionProvider;
import org.siouan.frontendgradleplugin.domain.usecase.ApplyAuthorization;

public class DownloadResource {
    public static final String AUTHORIZATION_HEADER = "Authorization";
    public static final String PROXY_AUTHORIZATION_HEADER = "Proxy-Authorization";
    public static final String TMP_EXTENSION = ".tmp";
    private final FileManager fileManager;
    private final ChannelProvider channelProvider;
    private final URLConnectionProvider urlConnectionProvider;
    private final ApplyAuthorization applyAuthorization;
    private final Logger logger;

    public DownloadResource(FileManager fileManager, ChannelProvider channelProvider, URLConnectionProvider urlConnectionProvider, ApplyAuthorization applyAuthorization, Logger logger) {
        this.fileManager = fileManager;
        this.channelProvider = channelProvider;
        this.urlConnectionProvider = urlConnectionProvider;
        this.applyAuthorization = applyAuthorization;
        this.logger = logger;
    }

    public void execute(@Nonnull DownloadSettings downloadSettings) throws IOException {
        URL resourceUrl = downloadSettings.getResourceUrl();
        String resourceName = downloadSettings.getDestinationFilePath().getFileName().toString();
        Path downloadedFilePath = downloadSettings.getTemporaryDirectoryPath().resolve(resourceName + TMP_EXTENSION);
        ProxySettings proxySettings = downloadSettings.getProxySettings();
        this.logger.debug("Downloading resource at '{}' (proxy: {})", downloadSettings.getResourceUrl(), proxySettings.getProxy());
        URLConnection urlConnection = this.urlConnectionProvider.openConnection(resourceUrl, proxySettings.getProxy());
        Credentials credentials = downloadSettings.getServerCredentials();
        if (credentials != null) {
            this.applyAuthorization.execute(urlConnection, AUTHORIZATION_HEADER, credentials);
        }
        if (proxySettings.getServerCredentials() != null) {
            this.applyAuthorization.execute(urlConnection, PROXY_AUTHORIZATION_HEADER, proxySettings.getServerCredentials());
        }
        try (ReadableByteChannel resourceInputChannel = this.channelProvider.getReadableByteChannel(urlConnection.getInputStream());
             FileChannel resourceOutputChannel = this.channelProvider.getWritableFileChannelForNewFile(downloadedFilePath, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            resourceOutputChannel.transferFrom(resourceInputChannel, 0L, Long.MAX_VALUE);
        }
        catch (IOException e) {
            this.fileManager.deleteIfExists(downloadedFilePath);
            throw e;
        }
        this.fileManager.move(downloadedFilePath, downloadSettings.getDestinationFilePath(), StandardCopyOption.REPLACE_EXISTING);
    }
}

