/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.domain.usecase;

import java.io.IOException;
import java.nio.file.Path;
import javax.annotation.Nonnull;
import org.siouan.frontendgradleplugin.domain.exception.ArchiverException;
import org.siouan.frontendgradleplugin.domain.exception.DistributionValidatorException;
import org.siouan.frontendgradleplugin.domain.exception.InvalidDistributionUrlException;
import org.siouan.frontendgradleplugin.domain.exception.UnsupportedDistributionArchiveException;
import org.siouan.frontendgradleplugin.domain.exception.UnsupportedDistributionIdException;
import org.siouan.frontendgradleplugin.domain.exception.UnsupportedPlatformException;
import org.siouan.frontendgradleplugin.domain.model.DeploymentSettings;
import org.siouan.frontendgradleplugin.domain.model.GetDistributionSettings;
import org.siouan.frontendgradleplugin.domain.model.InstallSettings;
import org.siouan.frontendgradleplugin.domain.model.Logger;
import org.siouan.frontendgradleplugin.domain.provider.FileManager;
import org.siouan.frontendgradleplugin.domain.usecase.DeployDistribution;
import org.siouan.frontendgradleplugin.domain.usecase.GetDistribution;

public abstract class AbstractInstallDistribution {
    public static final String EXTRACT_DIRECTORY_NAME = "extract";
    protected final FileManager fileManager;
    protected final GetDistribution getDistribution;
    protected final DeployDistribution deployDistribution;
    protected final Logger logger;

    protected AbstractInstallDistribution(FileManager fileManager, GetDistribution getDistribution, DeployDistribution deployDistribution, Logger logger) {
        this.fileManager = fileManager;
        this.getDistribution = getDistribution;
        this.deployDistribution = deployDistribution;
        this.logger = logger;
    }

    @Nonnull
    protected abstract String getDistributionId();

    public void execute(@Nonnull InstallSettings installSettings) throws UnsupportedDistributionArchiveException, ArchiverException, UnsupportedPlatformException, UnsupportedDistributionIdException, InvalidDistributionUrlException, DistributionValidatorException, IOException {
        this.logger.info("Removing install directory '{}'", installSettings.getInstallDirectoryPath());
        this.fileManager.deleteFileTree(installSettings.getInstallDirectoryPath(), true);
        GetDistributionSettings getDistributionSettings = new GetDistributionSettings(this.getDistributionId(), installSettings.getPlatform(), installSettings.getVersion(), installSettings.getDistributionUrlRoot(), installSettings.getDistributionUrlPathPattern(), installSettings.getDistributionServerCredentials(), installSettings.getProxySettings(), installSettings.getTemporaryDirectoryPath());
        Path distributionFilePath = this.getDistribution.execute(getDistributionSettings);
        this.deployDistribution.execute(new DeploymentSettings(installSettings.getPlatform(), installSettings.getTemporaryDirectoryPath().resolve(EXTRACT_DIRECTORY_NAME), installSettings.getInstallDirectoryPath(), distributionFilePath));
        this.logger.info("Removing distribution file '{}'", distributionFilePath);
        this.fileManager.delete(distributionFilePath);
        this.logger.info("Distribution installed in '{}'", installSettings.getInstallDirectoryPath());
    }
}

