/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.infrastructure.httpclient;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.siouan.frontendgradleplugin.domain.model.HttpResponse;

public class ApacheHttpResponse
implements HttpResponse {
    private final CloseableHttpClient httpClient;
    private final CloseableHttpResponse httpResponse;

    public ApacheHttpResponse(@Nonnull CloseableHttpClient httpClient, @Nonnull CloseableHttpResponse httpResponse) {
        this.httpClient = httpClient;
        this.httpResponse = httpResponse;
    }

    @Override
    @Nonnull
    public String getProtocol() {
        return this.httpResponse.getVersion().getProtocol();
    }

    @Override
    @Nonnull
    public String getVersion() {
        return this.httpResponse.getVersion().getMajor() + "." + this.httpResponse.getVersion().getMinor();
    }

    @Override
    public int getStatusCode() {
        return this.httpResponse.getCode();
    }

    @Override
    @Nonnull
    public String getReasonPhrase() {
        return this.httpResponse.getReasonPhrase();
    }

    @Override
    @Nonnull
    public InputStream getInputStream() throws IOException {
        HttpEntity httpEntity = this.httpResponse.getEntity();
        if (httpEntity == null) {
            return InputStream.nullInputStream();
        }
        return httpEntity.getContent();
    }

    @Override
    public void close() throws IOException {
        this.httpResponse.close();
        this.httpClient.close();
    }
}

