/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.infrastructure.httpclient;

import java.io.IOException;
import java.net.URL;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.auth.BasicScheme;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.siouan.frontendgradleplugin.domain.model.Credentials;
import org.siouan.frontendgradleplugin.domain.model.HttpResponse;
import org.siouan.frontendgradleplugin.domain.model.ProxySettings;
import org.siouan.frontendgradleplugin.domain.usecase.AbstractHttpClient;
import org.siouan.frontendgradleplugin.infrastructure.httpclient.ApacheHttpResponse;

public class ApacheHttpClient
extends AbstractHttpClient {
    @Override
    @Nonnull
    protected HttpResponse getRemoteResource(@Nonnull URL resourceUrl, @Nullable Credentials credentials, @Nullable ProxySettings proxySettings) throws IOException {
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        HttpClientContext httpClientContext = HttpClientContext.create();
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        if (credentials != null) {
            HttpHost serverHost = new HttpHost(resourceUrl.getProtocol(), resourceUrl.getHost(), resourceUrl.getPort());
            BasicScheme basicScheme = new BasicScheme();
            this.registerCredentials(credentialsProvider, basicScheme, serverHost, credentials.getUsername(), credentials.getPassword());
            httpClientContext.resetAuthExchange(serverHost, (AuthScheme)basicScheme);
        }
        if (proxySettings != null) {
            HttpHost proxyServerHost = new HttpHost(proxySettings.getProxyHost(), proxySettings.getProxyPort());
            Credentials proxyCredentials = proxySettings.getCredentials();
            if (proxyCredentials != null) {
                BasicScheme basicScheme = new BasicScheme();
                this.registerCredentials(credentialsProvider, basicScheme, proxyServerHost, proxyCredentials.getUsername(), proxyCredentials.getPassword());
                httpClientContext.resetAuthExchange(proxyServerHost, (AuthScheme)basicScheme);
            }
            requestConfigBuilder.setProxy(proxyServerHost);
        }
        HttpGet httpGet = new HttpGet(resourceUrl.toString());
        httpGet.setConfig(requestConfigBuilder.build());
        CloseableHttpClient httpClient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).build();
        try {
            return new ApacheHttpResponse(httpClient, httpClient.execute((ClassicHttpRequest)httpGet, (HttpContext)httpClientContext));
        }
        catch (IOException e) {
            httpClient.close();
            throw e;
        }
    }

    private void registerCredentials(@Nonnull BasicCredentialsProvider credentialsProvider, @Nonnull BasicScheme basicScheme, @Nonnull HttpHost host, @Nonnull String username, @Nonnull String password) {
        UsernamePasswordCredentials usernamePasswordCredentials = new UsernamePasswordCredentials(username, password.toCharArray());
        credentialsProvider.setCredentials(new AuthScope(host), (org.apache.hc.client5.http.auth.Credentials)usernamePasswordCredentials);
        basicScheme.initPreemptive((org.apache.hc.client5.http.auth.Credentials)usernamePasswordCredentials);
    }
}

