/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.infrastructure.gradle;

import javax.annotation.Nonnull;
import org.gradle.api.Task;
import org.gradle.api.logging.LogLevel;
import org.siouan.frontendgradleplugin.infrastructure.gradle.FrontendExtension;
import org.siouan.frontendgradleplugin.infrastructure.gradle.GradleSettings;
import org.siouan.frontendgradleplugin.infrastructure.gradle.adapter.GradleLoggerAdapter;

public class TaskLoggerConfigurer {
    private final FrontendExtension extension;
    private final GradleLoggerAdapter gradleLoggerAdapter;
    private final GradleSettings gradleSettings;

    public TaskLoggerConfigurer(FrontendExtension extension, GradleLoggerAdapter gradleLoggerAdapter, GradleSettings gradleSettings) {
        this.extension = extension;
        this.gradleLoggerAdapter = gradleLoggerAdapter;
        this.gradleSettings = gradleSettings;
    }

    public void initLoggerAdapter(@Nonnull Task task) {
        task.getLogger().debug("Configuring logger for task '{}': verboseModeEnabled={}", (Object)task.getName(), this.extension.getVerboseModeEnabled().get());
        this.gradleLoggerAdapter.init(task.getLogger(), this.resolveLogLevel(task), (Boolean)this.extension.getVerboseModeEnabled().get(), "[" + task.getName() + "] ");
    }

    @Nonnull
    private LogLevel resolveLogLevel(@Nonnull Task task) {
        LogLevel loggingLevel = task.getLogging().getLevel();
        if (loggingLevel != null) {
            return loggingLevel;
        }
        loggingLevel = this.gradleSettings.getProjectLogLevel();
        if (loggingLevel != null) {
            return loggingLevel;
        }
        return this.gradleSettings.getCommandLineLogLevel();
    }
}

