/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.domain.usecase;

import java.util.Optional;
import javax.annotation.Nonnull;
import org.siouan.frontendgradleplugin.domain.model.Platform;

public class ResolveNodeDistributionArchitectureId {
    private static final String LINUX_64_ARCH = "linux-x64";
    private static final String LINUX_ARM_32_ARCH = "linux-armv7l";
    private static final String MACOS_PPC_64_ARCH = "darwin-x64";
    private static final String MACOS_ARM_64_ARCH = "darwin-arm64";
    private static final String WINDOWS_32_ARCH = "win-x86";
    private static final String WINDOWS_64_ARCH = "win-x64";

    @Nonnull
    public Optional<String> execute(@Nonnull Platform platform) {
        String extension = platform.is64BitsArch() ? (platform.isWindowsOs() ? WINDOWS_64_ARCH : (platform.isLinuxOs() ? LINUX_64_ARCH : (platform.isMacOs() ? (platform.isArm64BitsArch() ? MACOS_ARM_64_ARCH : MACOS_PPC_64_ARCH) : null))) : (platform.isWindowsOs() ? WINDOWS_32_ARCH : (platform.isLinuxOs() && platform.isArm32BitsArch() ? LINUX_ARM_32_ARCH : null));
        return Optional.ofNullable(extension);
    }
}

