/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.domain.usecase;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.siouan.frontendgradleplugin.domain.exception.ExecutableNotFoundException;
import org.siouan.frontendgradleplugin.domain.model.ExecutionSettings;
import org.siouan.frontendgradleplugin.domain.model.Platform;
import org.siouan.frontendgradleplugin.domain.usecase.GetNodeExecutablePath;
import org.siouan.frontendgradleplugin.domain.usecase.ResolveExecutablePath;
import org.siouan.frontendgradleplugin.domain.util.StringSplitter;

public class ResolveExecutionSettings {
    public static final Path WINDOWS_EXECUTABLE_PATH = Paths.get("cmd", new String[0]);
    public static final String WINDOWS_EXECUTABLE_AUTOEXIT_FLAG = "/c";
    public static final Path UNIX_EXECUTABLE_PATH = Paths.get("/bin", "sh");
    public static final String UNIX_EXECUTABLE_AUTOEXIT_FLAG = "-c";
    public static final char UNIX_SCRIPT_ARG_SEPARATOR_CHAR = ' ';
    public static final char UNIX_SCRIPT_ARG_ESCAPE_CHAR = '\\';
    private final GetNodeExecutablePath getNodeExecutablePath;
    private final ResolveExecutablePath resolveExecutablePath;

    public ResolveExecutionSettings(GetNodeExecutablePath getNodeExecutablePath, ResolveExecutablePath resolveExecutablePath) {
        this.getNodeExecutablePath = getNodeExecutablePath;
        this.resolveExecutablePath = resolveExecutablePath;
    }

    @Nonnull
    public ExecutionSettings execute(@Nonnull Path packageJsonDirectoryPath, @Nonnull String executableType, @Nullable Path nodeInstallDirectoryPath, @Nonnull Platform platform, @Nonnull String script) throws ExecutableNotFoundException {
        Path nodeExecutableParentPath;
        Path executable;
        Path nodeExecutablePath = this.getNodeExecutablePath.execute(nodeInstallDirectoryPath, platform);
        Path scriptExecutablePath = this.resolveExecutablePath.execute(executableType, nodeInstallDirectoryPath, platform);
        ArrayList<String> args = new ArrayList<String>();
        if (platform.isWindowsOs()) {
            executable = WINDOWS_EXECUTABLE_PATH;
            args.add(WINDOWS_EXECUTABLE_AUTOEXIT_FLAG);
            if (scriptExecutablePath.getParent() == null) {
                args.add(scriptExecutablePath.toString() + " " + script.trim());
            } else {
                args.add(this.escapeWhitespacesFromCommandLineToken(scriptExecutablePath) + " " + script.trim());
            }
        } else {
            executable = UNIX_EXECUTABLE_PATH;
            args.add(UNIX_EXECUTABLE_AUTOEXIT_FLAG);
            args.add(this.escapeWhitespacesFromCommandLineToken(scriptExecutablePath) + " " + String.join((CharSequence)Character.toString(' '), new StringSplitter(' ', '\\').execute(script.trim())));
        }
        HashSet<Path> executablePaths = new HashSet<Path>();
        if (!executableType.equals("node") && (nodeExecutableParentPath = nodeExecutablePath.getParent()) != null) {
            executablePaths.add(nodeExecutableParentPath);
        }
        return new ExecutionSettings(packageJsonDirectoryPath, executablePaths, executable, args);
    }

    private String escapeWhitespacesFromCommandLineToken(Path path) {
        return "\"" + path.toString() + "\"";
    }
}

