/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.domain.usecase;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.siouan.frontendgradleplugin.domain.exception.FrontendException;
import org.siouan.frontendgradleplugin.domain.exception.InvalidDistributionUrlException;
import org.siouan.frontendgradleplugin.domain.model.DistributionDefinition;
import org.siouan.frontendgradleplugin.domain.model.DistributionValidatorSettings;
import org.siouan.frontendgradleplugin.domain.model.DownloadSettings;
import org.siouan.frontendgradleplugin.domain.model.GetDistributionSettings;
import org.siouan.frontendgradleplugin.domain.model.Logger;
import org.siouan.frontendgradleplugin.domain.usecase.BuildTemporaryFileName;
import org.siouan.frontendgradleplugin.domain.usecase.DownloadResource;
import org.siouan.frontendgradleplugin.domain.usecase.ResolveNodeDistributionUrl;
import org.siouan.frontendgradleplugin.domain.usecase.ValidateNodeDistribution;

public class GetDistribution {
    private static final Pattern URL_FILENAME_PATTERN = Pattern.compile("^.*/([^/]+)/*$");
    private final ResolveNodeDistributionUrl resolveNodeDistributionUrl;
    private final BuildTemporaryFileName buildTemporaryFileName;
    private final DownloadResource downloadResource;
    private final ValidateNodeDistribution validateNodeDistribution;
    private final Logger logger;

    public GetDistribution(ResolveNodeDistributionUrl resolveNodeDistributionUrl, BuildTemporaryFileName buildTemporaryFileName, DownloadResource downloadResource, ValidateNodeDistribution validateNodeDistribution, Logger logger) {
        this.resolveNodeDistributionUrl = resolveNodeDistributionUrl;
        this.buildTemporaryFileName = buildTemporaryFileName;
        this.downloadResource = downloadResource;
        this.validateNodeDistribution = validateNodeDistribution;
        this.logger = logger;
    }

    @Nonnull
    public Path execute(@Nonnull GetDistributionSettings getDistributionSettings) throws FrontendException, IOException {
        DistributionDefinition distributionDefinition = new DistributionDefinition(getDistributionSettings.getPlatform(), getDistributionSettings.getVersion(), getDistributionSettings.getDistributionUrlRoot(), getDistributionSettings.getDistributionUrlPathPattern());
        URL distributionUrl = this.resolveNodeDistributionUrl.execute(distributionDefinition);
        this.logger.info("Downloading distribution at '{}'", distributionUrl);
        Path distributionFilePath = getDistributionSettings.getTemporaryDirectoryPath().resolve(this.resolveDistributionFileName(distributionUrl));
        Path temporaryFilePath = getDistributionSettings.getTemporaryDirectoryPath().resolve(this.buildTemporaryFileName.execute(distributionFilePath.getFileName().toString()));
        this.downloadResource.execute(new DownloadSettings(distributionUrl, getDistributionSettings.getDistributionServerCredentials(), getDistributionSettings.getProxySettings(), temporaryFilePath, distributionFilePath));
        DistributionValidatorSettings distributionValidatorSettings = new DistributionValidatorSettings(getDistributionSettings.getTemporaryDirectoryPath(), distributionUrl, getDistributionSettings.getDistributionServerCredentials(), getDistributionSettings.getProxySettings(), distributionFilePath);
        this.validateNodeDistribution.execute(distributionValidatorSettings);
        return distributionFilePath;
    }

    @Nonnull
    private String resolveDistributionFileName(@Nonnull URL distributionUrl) throws InvalidDistributionUrlException {
        String distributionUrlPath = distributionUrl.getPath();
        Matcher fileNameMatcher = URL_FILENAME_PATTERN.matcher(distributionUrlPath);
        if (!fileNameMatcher.matches()) {
            throw new InvalidDistributionUrlException(distributionUrl);
        }
        return fileNameMatcher.group(1);
    }
}

