/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.domain.model;

import java.util.Arrays;
import javax.annotation.Nonnull;
import org.siouan.frontendgradleplugin.domain.model.Environment;

public class Platform {
    private static final String[] SUPPORTED_JVM_ARM_32_BITS_ARCH_IDS = new String[]{"arm"};
    private static final String[] SUPPORTED_JVM_ARM_64_BITS_ARCH_IDS = new String[]{"aarch64"};
    private static final String[] SUPPORTED_JVM_64_BITS_ARCH_IDS = new String[]{"x64", "x86_64", "amd64", "ppc", "sparc", "aarch64"};
    private static final String[] SUPPORTED_LINUX_OS_IDS = new String[]{"linux"};
    private static final String[] SUPPORTED_MAC_OS_IDS = new String[]{"mac os"};
    private static final String[] SUPPORTED_WINDOWS_OS_IDS = new String[]{"windows"};
    private final String jvmArch;
    private final String osName;
    private final Environment environment;

    public Platform(@Nonnull String jvmArch, @Nonnull String osName, @Nonnull Environment environment) {
        this.jvmArch = jvmArch;
        this.osName = osName;
        this.environment = environment;
    }

    public boolean is64BitsArch() {
        return this.matchesAnyIdPart(this.jvmArch, SUPPORTED_JVM_64_BITS_ARCH_IDS);
    }

    public boolean isArm64BitsArch() {
        return this.matchesAnyIdPart(this.jvmArch, SUPPORTED_JVM_ARM_64_BITS_ARCH_IDS);
    }

    public boolean isArm32BitsArch() {
        return this.matchesAnyIdPart(this.jvmArch, SUPPORTED_JVM_ARM_32_BITS_ARCH_IDS);
    }

    public boolean isLinuxOs() {
        return this.matchesAnyIdPart(this.osName, SUPPORTED_LINUX_OS_IDS);
    }

    public boolean isMacOs() {
        return this.matchesAnyIdPart(this.osName, SUPPORTED_MAC_OS_IDS);
    }

    public boolean isWindowsOs() {
        return this.matchesAnyIdPart(this.osName, SUPPORTED_WINDOWS_OS_IDS);
    }

    @Nonnull
    public Environment getEnvironment() {
        return this.environment;
    }

    public String toString() {
        return Platform.class.getSimpleName() + " {jvmArch=" + this.jvmArch + ", osName=" + this.osName + ", environment=" + this.environment + "}";
    }

    private boolean matchesAnyIdPart(@Nonnull String id, @Nonnull String[] parts) {
        String lowerCaseId = id.toLowerCase();
        return Arrays.stream(parts).anyMatch(lowerCaseId::contains);
    }
}

