/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.context.impl;

import java.util.List;
import org.simpleflatmapper.map.context.KeyAndPredicate;
import org.simpleflatmapper.map.context.KeySourceGetter;
import org.simpleflatmapper.util.ErrorHelper;
import org.simpleflatmapper.util.Predicate;

public class NullChecker<S, K>
implements Predicate<S> {
    private final List<KeyAndPredicate<S, K>> keys;
    private final KeySourceGetter<K, ? super S> keySourceGetter;

    public NullChecker(List<KeyAndPredicate<S, K>> keys, KeySourceGetter<K, ? super S> keySourceGetter) {
        this.keys = keys;
        this.keySourceGetter = keySourceGetter;
    }

    public boolean test(S s) {
        try {
            boolean empty = true;
            for (KeyAndPredicate<S, K> keyAndPredicate : this.keys) {
                if (!keyAndPredicate.test(s)) continue;
                empty = false;
                if (this.keySourceGetter.getValue(keyAndPredicate.key, s) == null) continue;
                return false;
            }
            return !empty;
        }
        catch (Exception e) {
            ErrorHelper.rethrow((Throwable)e);
            throw new IllegalStateException();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NullChecker that = (NullChecker)o;
        if (this.keys != null ? !this.keys.equals(that.keys) : that.keys != null) {
            return false;
        }
        return this.keySourceGetter != null ? this.keySourceGetter.equals(that.keySourceGetter) : that.keySourceGetter == null;
    }

    public int hashCode() {
        int result = this.keys != null ? this.keys.hashCode() : 0;
        result = 31 * result + (this.keySourceGetter != null ? this.keySourceGetter.hashCode() : 0);
        return result;
    }
}

