/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.api.visual.element;

import java.awt.image.BufferedImage;
import java.util.EventListener;
import javax.swing.event.EventListenerList;
import org.sikuli.api.visual.element.Element;

public class ImageElement
extends Element {
    private BufferedImage image;
    EventListenerList listenerList = new EventListenerList();

    public BufferedImage getImage() {
        return this.image;
    }

    public void setImage(BufferedImage image) {
        this.image = image;
        this.fireUpdate(image);
    }

    public void addListener(Listener l) {
        this.listenerList.add(Listener.class, l);
    }

    public void removeListener(Listener l) {
        this.listenerList.remove(Listener.class, l);
    }

    protected void fireUpdate(BufferedImage newImage) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != Listener.class) continue;
            ((Listener)listeners[i + 1]).imageUpdated(newImage);
        }
    }

    public static interface Listener
    extends EventListener {
        public void imageUpdated(BufferedImage var1);
    }
}

