/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.api.visual;

import java.awt.image.BufferedImage;
import org.sikuli.api.Location;
import org.sikuli.api.Region;
import org.sikuli.api.visual.Canvas;
import org.sikuli.api.visual.element.BoxElement;
import org.sikuli.api.visual.element.CircleElement;
import org.sikuli.api.visual.element.DotElement;
import org.sikuli.api.visual.element.Element;
import org.sikuli.api.visual.element.ElementStyleSetter;
import org.sikuli.api.visual.element.ImageElement;
import org.sikuli.api.visual.element.LabelElement;

public class CanvasBuilder {
    private Canvas canvas;

    public CanvasBuilder(Canvas canvas) {
        this.canvas = canvas;
    }

    private Element addElement(Element element) {
        this.canvas.add(element);
        return element;
    }

    public class ElementAreaSetter {
        private Element element;

        public ElementAreaSetter(Element element) {
            this.element = element;
        }

        public ElementPointSetter size(int width, int height) {
            this.element.width = width;
            this.element.height = height;
            return new ElementPointSetter(this.element);
        }

        public Element around(int x, int y, int width, int height) {
            this.element.x = x;
            this.element.y = y;
            this.element.width = width;
            this.element.height = height;
            return this.element;
        }

        public Element around(Region r) {
            this.element.x = r.getX();
            this.element.y = r.getY();
            this.element.width = r.getWidth();
            this.element.height = r.getHeight();
            return this.element;
        }
    }

    public class RelativeToRegion
    extends ElementSetter {
        int x;
        int y;
        int width;
        int height;

        public RelativeToRegion(Element element, int x, int y, int width, int height) {
            super(element);
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public RelativeToRegion above(int d) {
            this.element.x = this.x;
            this.element.y = this.y - d;
            return this;
        }

        public ElementStyleSetter styleWith() {
            return new ElementStyleSetter(this.element);
        }
    }

    public class ElementSetter {
        protected Element element;

        public ElementSetter(Element element) {
            this.element = element;
        }
    }

    public class ElementPointSetter {
        private Element element;

        public ElementPointSetter(Element element) {
            this.element = element;
        }

        public Element at(int x, int y) {
            this.element.x = x;
            this.element.y = y;
            return this.element;
        }

        public Element at(Location p) {
            this.element.x = p.getX();
            this.element.y = p.getY();
            return this.element;
        }

        public Element centeredAt(int x, int y) {
            this.element.x = x - this.element.width / 2;
            this.element.y = y - this.element.height / 2;
            return this.element;
        }

        public Element centeredAt(Region r) {
            this.element.x = r.getX() + r.getWidth() / 2 - this.element.width / 2;
            this.element.y = r.getY() + r.getHeight() / 2 - this.element.height / 2;
            this.element.horizontalAlignment = Element.HorizontalAlignment.CENTER;
            this.element.verticalAlignment = Element.VerticalAlignment.MIDDLE;
            return this.element;
        }

        public Element centeredAbove(Region r) {
            return null;
        }

        public RelativeToRegion relativeTo(Region r) {
            return new RelativeToRegion(this.element, r.getX(), r.getY(), r.getWidth(), r.getHeight());
        }
    }

    public class LabelElementPlacementSetter
    extends ElementSetter {
        public LabelElementPlacementSetter(Element element) {
            super(element);
        }

        public Element at(Location p) {
            this.element.x = p.getX();
            this.element.y = p.getY();
            return this.element;
        }

        public Element at(int x, int y) {
            this.element.x = x;
            this.element.y = y;
            return this.element;
        }

        public Element inside(Region r) {
            this.element.x = r.getX() + r.getWidth() / 2 - this.element.width / 2;
            this.element.y = r.getY() + r.getHeight() / 2 - this.element.height / 2;
            this.element.horizontalAlignment = Element.HorizontalAlignment.CENTER;
            this.element.verticalAlignment = Element.VerticalAlignment.MIDDLE;
            return this.element;
        }

        public Element below(Region r) {
            this.element.x = r.getX() + r.getWidth() / 2 - this.element.width / 2;
            this.element.y = r.getY() + r.getHeight();
            this.element.horizontalAlignment = Element.HorizontalAlignment.CENTER;
            return this.element;
        }

        public Element above(Region r) {
            this.element.x = r.getX() + r.getWidth() / 2 - this.element.width / 2;
            this.element.y = r.getY();
            this.element.horizontalAlignment = Element.HorizontalAlignment.CENTER;
            this.element.verticalAlignment = Element.VerticalAlignment.BOTTOM;
            return this.element;
        }

        public Element left(Region r) {
            this.element.x = r.getX();
            this.element.y = r.getY() + r.getHeight() / 2;
            this.element.horizontalAlignment = Element.HorizontalAlignment.RIGHT;
            this.element.verticalAlignment = Element.VerticalAlignment.MIDDLE;
            return this.element;
        }

        public Element right(Region r) {
            this.element.x = r.getX() + r.getWidth();
            this.element.y = r.getY() + r.getHeight() / 2;
            this.element.horizontalAlignment = Element.HorizontalAlignment.LEFT;
            this.element.verticalAlignment = Element.VerticalAlignment.MIDDLE;
            return this.element;
        }
    }

    public class ElementAdder {
        public ElementAreaSetter box() {
            BoxElement newElement = new BoxElement();
            CanvasBuilder.this.addElement(newElement);
            return new ElementAreaSetter(newElement);
        }

        public ElementAreaSetter circle() {
            CircleElement newElement = new CircleElement();
            CanvasBuilder.this.addElement(newElement);
            return new ElementAreaSetter(newElement);
        }

        public ElementPointSetter dot() {
            DotElement newElement = new DotElement();
            CanvasBuilder.this.addElement(newElement);
            return new ElementPointSetter(newElement);
        }

        public LabelElementPlacementSetter label(String labelText) {
            LabelElement newElement = new LabelElement();
            newElement.setText(labelText);
            CanvasBuilder.this.addElement(newElement);
            return new LabelElementPlacementSetter(newElement);
        }

        public ElementPointSetter image(BufferedImage image) {
            ImageElement newElement = new ImageElement();
            newElement.setImage(image);
            CanvasBuilder.this.addElement(newElement);
            return new ElementPointSetter(newElement);
        }
    }
}

