/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.web.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openqa.grid.common.GridRole;
import org.openqa.grid.web.servlet.DisplayHelpHandler;
import org.openqa.selenium.grid.server.ServletRequestWrappingHttpRequest;
import org.openqa.selenium.grid.server.ServletResponseWrappingHttpResponse;
import org.openqa.selenium.grid.web.CommandHandler;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

public class DisplayHelpServlet
extends HttpServlet {
    private static final long serialVersionUID = 8484071790930378855L;
    public static final String HELPER_TYPE_PARAMETER = "webdriver.server.displayhelpservlet.type";
    private CommandHandler handler;

    public void init() throws ServletException {
        super.init();
        this.handler = new DisplayHelpHandler(new Json(), this.getHelperType(), this.getInitParameter("webdriver.server.consoleservlet.path", ""));
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.process(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.process(request, response);
    }

    protected void process(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.handler.execute((HttpRequest)new ServletRequestWrappingHttpRequest(request), (HttpResponse)new ServletResponseWrappingHttpResponse(response));
    }

    private GridRole getHelperType() {
        GridRole role = GridRole.get(this.getInitParameter(HELPER_TYPE_PARAMETER, "standalone"));
        if (role == null) {
            role = GridRole.NOT_GRID;
        }
        return role;
    }

    public String getInitParameter(String param) {
        return this.getServletContext().getInitParameter(param);
    }

    private String getInitParameter(String param, String defaultValue) {
        String value = this.getInitParameter(param);
        if (value == null || value.trim().isEmpty()) {
            return defaultValue;
        }
        return value;
    }
}

