/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal.utils.configuration.converters;

import com.beust.jcommander.IStringConverter;
import org.openqa.grid.common.exception.GridConfigurationException;
import org.openqa.grid.internal.listeners.Prioritizer;
import org.openqa.grid.internal.utils.CapabilityMatcher;

public abstract class StringToClassConverter<E> {
    public E convert(String clazz) {
        try {
            return (E)Class.forName(clazz).newInstance();
        }
        catch (Throwable e) {
            throw new GridConfigurationException("Error creating class with " + clazz + " : " + e.getMessage(), e);
        }
    }

    public static class PrioritizerStringConverter
    extends StringToClassConverter<Prioritizer>
    implements IStringConverter<Prioritizer> {
    }

    public static class CapabilityMatcherStringConverter
    extends StringToClassConverter<CapabilityMatcher>
    implements IStringConverter<CapabilityMatcher> {
    }
}

