/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.commandhandler;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.grid.web.CommandHandler;
import org.openqa.selenium.io.Zip;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.server.ActiveSession;

public class UploadFile
implements CommandHandler {
    private final Json json;
    private final ActiveSession session;

    public UploadFile(Json json, ActiveSession session) {
        this.json = Objects.requireNonNull(json);
        this.session = Objects.requireNonNull(session);
    }

    @Override
    public void execute(HttpRequest req, HttpResponse resp) throws IOException {
        Map args = (Map)this.json.toType(req.getContentString(), Json.MAP_TYPE);
        String file = (String)args.get("file");
        File tempDir = this.session.getFileSystem().createTempDir("upload", "file");
        Zip.unzip((String)file, (File)tempDir);
        File[] allFiles = tempDir.listFiles();
        Response response = new Response(this.session.getId());
        if (allFiles == null || allFiles.length != 1) {
            response.setStatus(Integer.valueOf(13));
            response.setValue((Object)new WebDriverException("Expected there to be only 1 file. There were: " + (allFiles == null ? 0 : allFiles.length)));
        } else {
            response.setStatus(Integer.valueOf(0));
            response.setValue((Object)allFiles[0].getAbsolutePath());
        }
        this.session.getDownstreamDialect().getResponseCodec().encode(() -> resp, response);
    }
}

