/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.browserlaunchers.LauncherUtils;
import org.openqa.selenium.browserlaunchers.MacProxyManager;
import org.openqa.selenium.browserlaunchers.WindowsProxyManager;
import org.openqa.selenium.browserlaunchers.locators.BrowserInstallation;
import org.openqa.selenium.browserlaunchers.locators.BrowserLocator;
import org.openqa.selenium.browserlaunchers.locators.SafariLocator;
import org.openqa.selenium.os.CommandLine;
import org.openqa.selenium.os.WindowsUtils;
import org.openqa.selenium.server.ApplicationRegistry;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.browserlaunchers.AbstractBrowserLauncher;
import org.openqa.selenium.server.browserlaunchers.InvalidBrowserExecutableException;

public class SafariCustomProfileLauncher
extends AbstractBrowserLauncher {
    private static final Logger log = Logger.getLogger(SafariCustomProfileLauncher.class.getName());
    private static final String REDIRECT_TO_GO_TO_SELENIUM = "redirect_to_go_to_selenium.htm";
    protected File customProfileDir;
    protected String[] cmdarray;
    private boolean closed = false;
    protected BrowserInstallation browserInstallation;
    protected CommandLine process;
    protected WindowsProxyManager wpm;
    protected MacProxyManager mpm;
    private File backedUpCookieFile;
    private File originalCookieFile;
    private String originalCookieFilePath;

    protected BrowserInstallation locateSafari(String browserLaunchLocation) {
        return ApplicationRegistry.instance().browserInstallationCache().locateBrowserInstallation("safari", browserLaunchLocation, (BrowserLocator)new SafariLocator());
    }

    public SafariCustomProfileLauncher(Capabilities browserOptions, RemoteControlConfiguration configuration, String sessionId, String browserLaunchLocation) {
        super(sessionId, configuration, browserOptions);
        this.browserInstallation = this.locateSafari(browserLaunchLocation);
        if (this.browserInstallation == null) {
            log.severe("The specified path to the browser executable is invalid.");
            throw new InvalidBrowserExecutableException("The specified path to the browser executable is invalid.");
        }
        if (configuration.shouldOverrideSystemProxy()) {
            this.createSystemProxyManager(sessionId);
        }
        this.customProfileDir = LauncherUtils.createCustomProfileDir((String)sessionId);
    }

    @Override
    protected void launch(String url) {
        if (!this.browserConfigurationOptions.is("honorSystemProxy")) {
            this.setupSystemProxy();
        }
        if (this.browserConfigurationOptions.is("ensureCleanSession")) {
            this.ensureCleanSession();
        }
        this.launchSafari(url);
    }

    protected void launchSafari(String url) {
        this.cmdarray = new String[]{this.browserInstallation.launcherFilePath()};
        if (Platform.getCurrent().is(Platform.MAC)) {
            String redirectHtmlFileName = this.makeRedirectionHtml(this.customProfileDir, url);
            log.info("Launching Safari to visit '" + url + "' via '" + redirectHtmlFileName + "'...");
            this.cmdarray = new String[]{this.browserInstallation.launcherFilePath(), redirectHtmlFileName};
        } else {
            log.info("Launching Safari ...");
            this.cmdarray = new String[]{this.browserInstallation.launcherFilePath(), "-url", url};
        }
        this.process = new CommandLine(this.cmdarray);
        this.process.setDynamicLibraryPath(this.browserInstallation.libraryPath());
        this.process.executeAsync();
    }

    public void close() {
        if (this.closed) {
            return;
        }
        if (!this.browserConfigurationOptions.is("honorSystemProxy")) {
            this.restoreSystemProxy();
        }
        if (this.process == null) {
            return;
        }
        log.info("Killing Safari...");
        int exitValue = this.process.destroy();
        if (exitValue == 0) {
            log.warning("Safari seems to have ended on its own (did we kill the real browser???)");
        }
        this.closed = true;
        if (this.backedUpCookieFile != null && this.backedUpCookieFile.exists()) {
            File sessionCookieFile = new File(this.originalCookieFilePath);
            boolean success = sessionCookieFile.delete();
            if (success) {
                log.info("Session's cookie file deleted.");
            } else {
                log.info("Session's cookie *not* deleted.");
            }
            log.info("Trying to restore originalCookieFile...");
            this.originalCookieFile = new File(this.originalCookieFilePath);
            LauncherUtils.copySingleFile((File)this.backedUpCookieFile, (File)this.originalCookieFile);
        }
    }

    protected void ensureCleanSession() {
        if (Platform.getCurrent().is(Platform.MAC)) {
            String user = System.getenv("USER");
            File cacheDir = new File("/Users/" + user + "/Library/Caches/Safari");
            this.originalCookieFilePath = "/Users/" + user + "/Library/Cookies" + "/Cookies.plist";
            this.originalCookieFile = new File(this.originalCookieFilePath);
            LauncherUtils.deleteTryTryAgain((File)cacheDir, (int)6);
        } else {
            File cacheFile;
            this.originalCookieFilePath = System.getenv("APPDATA") + "/Apple Computer/Safari/Cookies/Cookies.plist";
            this.originalCookieFile = new File(this.originalCookieFilePath);
            String localAppData = System.getenv("LOCALAPPDATA");
            if (localAppData == null) {
                localAppData = System.getenv("USERPROFILE") + "/Local Settings/Application Data";
            }
            if ((cacheFile = new File(localAppData + "/Apple Computer/Safari/Cache.db")).exists()) {
                cacheFile.delete();
            }
        }
        log.info("originalCookieFilePath: " + this.originalCookieFilePath);
        String backedUpCookieFilePath = this.customProfileDir.toString() + "/Cookies.plist";
        this.backedUpCookieFile = new File(backedUpCookieFilePath);
        log.info("backedUpCookieFilePath: " + backedUpCookieFilePath);
        if (this.originalCookieFile.exists()) {
            LauncherUtils.copySingleFile((File)this.originalCookieFile, (File)this.backedUpCookieFile);
            this.originalCookieFile.delete();
        }
    }

    protected String makeRedirectionHtml(File parentDir, String url) {
        File f = new File(parentDir, REDIRECT_TO_GO_TO_SELENIUM);
        PrintStream out = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(f);
            out = new PrintStream(fileOutputStream);
            out.println("<script language=\"JavaScript\">\n    location = \"" + url + "\"\n" + "</script>\n");
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("troublemaking redirection HTML: " + e);
        }
        finally {
            if (null != out) {
                out.close();
            }
            if (null != fileOutputStream) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    log.log(Level.WARNING, "Ignoring exception while closing HTML redirection stream", e);
                }
            }
        }
        return f.getAbsolutePath();
    }

    private void setupSystemProxy() {
        if (WindowsUtils.thisIsWindows()) {
            this.wpm.backupRegistrySettings();
            this.changeRegistrySettings();
        } else {
            this.mpm.backupNetworkSettings();
            this.mpm.changeNetworkSettings();
        }
    }

    private void restoreSystemProxy() {
        if (WindowsUtils.thisIsWindows()) {
            this.wpm.restoreRegistrySettings(this.browserConfigurationOptions.is("ensureCleanSession"));
        } else {
            this.mpm.restoreNetworkSettings();
        }
    }

    protected void changeRegistrySettings() {
        this.wpm.changeRegistrySettings(this.browserConfigurationOptions);
    }

    private void createSystemProxyManager(String sessionId) {
        if (WindowsUtils.thisIsWindows()) {
            this.wpm = new WindowsProxyManager(true, sessionId, this.getPort(), this.getPort());
        } else {
            this.mpm = new MacProxyManager(sessionId, this.getPort());
        }
    }
}

