/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.jetty.http.HttpRequest;
import org.openqa.jetty.http.HttpResponse;
import org.openqa.jetty.util.IO;
import org.openqa.selenium.server.ClassPathResource;
import org.openqa.selenium.server.HtmlIdentifier;
import org.openqa.selenium.server.ModifiedIO;
import org.openqa.selenium.server.SessionIdTracker;

public class InjectionHelper {
    static Logger log = Logger.getLogger(InjectionHelper.class.getName());
    private static boolean failOnError = true;
    private static boolean browserSideLogEnabled = true;
    private static boolean INJECT_SCRIPT_TAGS = true;
    private static boolean tryToInjectInHead = false;
    private static String injectionHtml = "/core/scripts/injection.html";
    private static HashMap<String, HashMap<String, String>> jsStateInitializersBySessionId = new HashMap();
    private static HashMap<String, String> sessionIdToUniqueId = new HashMap();
    private static HashMap<String, String> contentTransformations = new HashMap();
    private static List<String> userJsInjectionFiles = new LinkedList<String>();

    public static void setBrowserSideLogEnabled(boolean browserSideLogEnabled) {
        InjectionHelper.browserSideLogEnabled = browserSideLogEnabled;
    }

    public static void setInjectScriptTags(boolean injectScriptTags) {
        INJECT_SCRIPT_TAGS = injectScriptTags;
    }

    public static void setTryToInjectInHead(boolean tryToInjectInHead) {
        InjectionHelper.tryToInjectInHead = tryToInjectInHead;
    }

    public static void setInjectionHtml(String injectionHtml) {
        InjectionHelper.injectionHtml = injectionHtml;
    }

    public static void saveJsStateInitializer(String sessionId, String uniqueId, String jsVarName, String jsStateInitializer) {
        if (sessionIdToUniqueId.containsKey(sessionId) && !sessionIdToUniqueId.get(sessionId).equals(uniqueId)) {
            jsStateInitializersBySessionId.remove(sessionId);
            sessionIdToUniqueId.put(sessionId, uniqueId);
        }
        log.fine("Saving JavaScript state for session " + sessionId + "/" + uniqueId + " " + jsVarName + ": " + jsStateInitializer);
        if (!jsStateInitializersBySessionId.containsKey(sessionId)) {
            jsStateInitializersBySessionId.put(sessionId, new HashMap());
        }
        HashMap<String, String> h = jsStateInitializersBySessionId.get(sessionId);
        StringBuffer sb = new StringBuffer("if (uniqueId!='");
        sb.append(uniqueId).append("') {").append(jsStateInitializer).append("}");
        h.put(jsVarName, sb.toString());
    }

    public static String restoreJsStateInitializer(String sessionId, String uniqueId) {
        if (!jsStateInitializersBySessionId.containsKey(sessionId)) {
            return "";
        }
        HashMap<String, String> h = jsStateInitializersBySessionId.get(sessionId);
        if (h.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, String> entry : h.entrySet()) {
            String jsVarName = entry.getKey();
            String jsStateInitializer = entry.getValue();
            sb.append(jsStateInitializer).append('\n');
            log.fine("Restoring JavaScript state for session " + sessionId + "/" + uniqueId + ": key=" + jsVarName + ": " + jsStateInitializer);
        }
        return sb.toString();
    }

    public static void init() {
        String key = "__SELENIUM_JS__";
        StringBuffer sb = new StringBuffer();
        if (!INJECT_SCRIPT_TAGS) {
            try {
                InjectionHelper.appendFileContent(sb, "/core/scripts/xmlextras.js");
                InjectionHelper.appendFileContent(sb, "/core/lib/sizzle.js");
                InjectionHelper.appendFileContent(sb, "/core/scripts/htmlutils.js");
                InjectionHelper.appendFileContent(sb, "/core/scripts/ui-element.js");
                InjectionHelper.appendFileContent(sb, "/core/scripts/selenium-browserdetect.js");
                InjectionHelper.appendFileContent(sb, "/core/scripts/selenium-browserbot.js");
                InjectionHelper.appendFileContent(sb, "/core/scripts/find_matching_child.js");
                InjectionHelper.appendFileContent(sb, "/core/scripts/selenium-api.js");
                InjectionHelper.appendFileContent(sb, "/core/scripts/selenium-commandhandlers.js");
                InjectionHelper.appendFileContent(sb, "/core/scripts/selenium-executionloop.js");
                InjectionHelper.appendFileContent(sb, "/core/scripts/selenium-remoterunner.js");
                InjectionHelper.appendFileContent(sb, "/core/scripts/selenium-logging.js");
                InjectionHelper.appendFileContent(sb, "/core/xpath/util.js");
                InjectionHelper.appendFileContent(sb, "/core/xpath/xmltoken.js");
                InjectionHelper.appendFileContent(sb, "/core/xpath/dom.js");
                InjectionHelper.appendFileContent(sb, "/core/xpath/xpath.js");
                InjectionHelper.appendFileContent(sb, "/core/xpath/javascript-xpath-0.1.12.js");
                InjectionHelper.appendFileContent(sb, "/core/scripts/user-extensions.js");
            }
            catch (Exception e) {
                if (failOnError) {
                    throw new RuntimeException(e);
                }
                log.info("failOnError is false, ignoring problems: " + e.getMessage());
                log.log(Level.FINE, "Ignored exception", e);
            }
        }
        contentTransformations.put(key, sb.toString());
    }

    private static void writeScriptTags(OutputStream os) throws IOException {
        InjectionHelper.writeScriptTag(os, "/core/scripts/xmlextras.js");
        InjectionHelper.writeScriptTag(os, "/core/lib/sizzle.js");
        InjectionHelper.writeScriptTag(os, "/core/scripts/atoms.js");
        InjectionHelper.writeScriptTag(os, "/core/scripts/htmlutils.js");
        InjectionHelper.writeScriptTag(os, "/core/scripts/ui-element.js");
        InjectionHelper.writeScriptTag(os, "/core/scripts/selenium-browserdetect.js");
        InjectionHelper.writeScriptTag(os, "/core/scripts/selenium-browserbot.js");
        InjectionHelper.writeScriptTag(os, "/core/scripts/find_matching_child.js");
        InjectionHelper.writeScriptTag(os, "/core/scripts/selenium-api.js");
        InjectionHelper.writeScriptTag(os, "/core/scripts/selenium-commandhandlers.js");
        InjectionHelper.writeScriptTag(os, "/core/scripts/selenium-executionloop.js");
        InjectionHelper.writeScriptTag(os, "/core/scripts/selenium-remoterunner.js");
        InjectionHelper.writeScriptTag(os, "/core/scripts/selenium-logging.js");
        InjectionHelper.writeScriptTag(os, "/core/xpath/util.js");
        InjectionHelper.writeScriptTag(os, "/core/xpath/xmltoken.js");
        InjectionHelper.writeScriptTag(os, "/core/xpath/dom.js");
        InjectionHelper.writeScriptTag(os, "/core/xpath/xpath.js");
        InjectionHelper.writeScriptTag(os, "/core/xpath/javascript-xpath-0.1.12.js");
        InjectionHelper.writeScriptTag(os, "/core/scripts/user-extensions.js");
    }

    private static void writeScriptTag(OutputStream os, String url) throws IOException {
        os.write("<script type=\"text/javascript\" src=\"/selenium-server".getBytes());
        os.write(url.getBytes());
        os.write("\"></script>\n".getBytes());
    }

    private static void appendFileContent(StringBuffer sb, String url) throws IOException {
        InputStream in = new ClassPathResource(url).getInputStream();
        if (in == null) {
            if (!url.endsWith("user-extensions.js")) {
                throw new RuntimeException("couldn't find " + url);
            }
        } else {
            int len;
            byte[] buf = new byte[8192];
            while ((len = in.read(buf, 0, 8192)) != -1) {
                sb.append(new String(buf, 0, len));
            }
        }
    }

    public static long injectJavaScript(HttpRequest request, HttpResponse response, InputStream in, OutputStream out, String debugURL) throws IOException {
        if (!contentTransformations.containsKey("__SELENIUM_JS__")) {
            InjectionHelper.init();
        }
        int len = 102400;
        byte[] buf = new byte[len];
        if ((len = InjectionHelper.readStream(in, buf, len)) == -1) {
            return -1L;
        }
        int lengthOfBOM = InjectionHelper.getBOMLength(buf);
        String data = new String(buf, lengthOfBOM, len);
        boolean isKnownToBeHtml = HtmlIdentifier.shouldBeInjected(request.getPath(), response.getContentType(), data);
        String url = response.getHttpRequest().getRequestURL().toString();
        if (debugURL.equals(url)) {
            log.info("debug URL seen");
        }
        if (!isKnownToBeHtml) {
            out.write(buf, 0, len);
        }
        String sessionId = SessionIdTracker.getLastSessionId();
        long bytesCopied = len;
        log.fine(url + " (InjectionHelper looking)");
        if (!isKnownToBeHtml) {
            bytesCopied += ModifiedIO.copy(in, out);
        } else {
            log.fine("injecting...");
            response.removeField("Content-Length");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (INJECT_SCRIPT_TAGS) {
                InjectionHelper.writeScriptTags(baos);
            }
            InputStream jsIn = new ClassPathResource(injectionHtml).getInputStream();
            contentTransformations.put("@SESSION_ID@", sessionId);
            InjectionHelper.writeDataWithUserTransformations("", jsIn, baos);
            jsIn.close();
            baos.write(InjectionHelper.setSomeJsVars(sessionId));
            for (String filename : userJsInjectionFiles) {
                jsIn = new FileInputStream(filename);
                IO.copy((InputStream)jsIn, (OutputStream)baos);
            }
            int headIndex = tryToInjectInHead ? data.toLowerCase().indexOf("<head>") : -1;
            data = headIndex != -1 ? data.substring(0, headIndex + 6) + baos.toString() + data.substring(headIndex + 6) : baos.toString() + data;
            bytesCopied += InjectionHelper.writeDataWithUserTransformations(data, in, out);
        }
        return bytesCopied;
    }

    private static int getBOMLength(byte[] buf) {
        if (buf != null && buf.length >= 3 && buf[0] == -17 && buf[1] == -69 && buf[2] == -65) {
            return 3;
        }
        return 0;
    }

    private static int readStream(InputStream in, byte[] buf, int bufLen) throws IOException {
        int bytesRead;
        int offset = 0;
        while ((bytesRead = in.read(buf, offset, bufLen - offset)) != -1 && (offset += bytesRead) < bufLen) {
        }
        int bytesReadTotal = offset;
        return bytesReadTotal;
    }

    private static long writeDataWithUserTransformations(String data, InputStream in, OutputStream out) throws IOException {
        long bytesWritten = 0L;
        byte[] buf = new byte[8192];
        while (true) {
            for (String beforeRegexp : contentTransformations.keySet()) {
                String after = contentTransformations.get(beforeRegexp);
                if (after == null) {
                    log.warning("no transformation seen for key " + beforeRegexp);
                    continue;
                }
                try {
                    data = data.replaceAll(beforeRegexp, after);
                }
                catch (IllegalArgumentException e) {
                    data = data.replace(beforeRegexp, after);
                }
            }
            out.write(data.getBytes());
            int len = in.read(buf);
            if (len == -1) break;
            bytesWritten += (long)len;
            data = new String(buf, 0, len);
        }
        return bytesWritten;
    }

    private static byte[] setSomeJsVars(String sessionId) {
        StringBuffer moreJs = new StringBuffer();
        if (browserSideLogEnabled) {
            moreJs.append("debugMode = true;\n");
        }
        moreJs.append("injectedSessionId = \"").append(sessionId).append("\";\n");
        return InjectionHelper.makeJsChunk(moreJs.toString());
    }

    private static byte[] makeJsChunk(String js) {
        StringBuffer sb = new StringBuffer("\n<script language=\"JavaScript\">\n");
        sb.append(js).append("\n</script>\n");
        return sb.toString().getBytes();
    }

    public static boolean addUserContentTransformation(String before, String after) {
        contentTransformations.put(before, after);
        return true;
    }

    public static boolean addUserJsInjectionFile(String fileName) {
        File f = new File(fileName);
        if (!f.canRead()) {
            log.severe("cannot read user JavaScript injection file " + fileName);
            return false;
        }
        userJsInjectionFiles.add(fileName);
        return true;
    }

    public static boolean userContentTransformationsExist() {
        return !contentTransformations.isEmpty();
    }

    public static boolean userJsInjectionsExist() {
        return !userJsInjectionFiles.isEmpty();
    }

    public static boolean isFailOnError() {
        return failOnError;
    }

    public static void setFailOnError(boolean failOnError) {
        InjectionHelper.failOnError = failOnError;
    }
}

