/*
 * Decompiled with CFR 0.152.
 */
package com.steadystate.css.dom;

import com.steadystate.css.dom.DOMExceptionImpl;
import com.steadystate.css.dom.Property;
import com.steadystate.css.format.CSSFormat;
import com.steadystate.css.format.CSSFormatable;
import com.steadystate.css.parser.CSSOMParser;
import com.steadystate.css.util.LangUtils;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSSStyleDeclarationImpl
implements CSSStyleDeclaration,
CSSFormatable,
Serializable {
    private static final long serialVersionUID = -2373755821317100189L;
    private static final String PRIORITY_IMPORTANT = "important";
    private CSSRule parentRule_;
    private List<Property> properties_ = new ArrayList<Property>();

    public void setParentRule(CSSRule parentRule) {
        this.parentRule_ = parentRule;
    }

    public List<Property> getProperties() {
        return this.properties_;
    }

    public void setProperties(List<Property> properties) {
        this.properties_ = properties;
    }

    public CSSStyleDeclarationImpl(CSSRule parentRule) {
        this.parentRule_ = parentRule;
    }

    public CSSStyleDeclarationImpl() {
    }

    @Override
    public String getCssText() {
        return this.getCssText(null);
    }

    @Override
    public String getCssText(CSSFormat format) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.properties_.size(); ++i) {
            Property p = this.properties_.get(i);
            if (p != null) {
                sb.append(p.getCssText(format));
            }
            if (i >= this.properties_.size() - 1) continue;
            sb.append("; ");
        }
        return sb.toString();
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        try {
            InputSource is = new InputSource(new StringReader(cssText));
            CSSOMParser parser = new CSSOMParser();
            this.properties_.clear();
            parser.parseStyleDeclaration(this, is);
        }
        catch (Exception e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
    }

    @Override
    public String getPropertyValue(String propertyName) {
        Property p = this.getPropertyDeclaration(propertyName);
        return p == null || p.getValue() == null ? "" : p.getValue().toString();
    }

    @Override
    public CSSValue getPropertyCSSValue(String propertyName) {
        Property p = this.getPropertyDeclaration(propertyName);
        return p == null ? null : p.getValue();
    }

    @Override
    public String removeProperty(String propertyName) throws DOMException {
        if (null == propertyName) {
            return "";
        }
        for (int i = 0; i < this.properties_.size(); ++i) {
            Property p = this.properties_.get(i);
            if (p == null || !propertyName.equalsIgnoreCase(p.getName())) continue;
            this.properties_.remove(i);
            return p.getValue() == null ? "" : p.getValue().toString();
        }
        return "";
    }

    @Override
    public String getPropertyPriority(String propertyName) {
        Property p = this.getPropertyDeclaration(propertyName);
        if (p == null) {
            return "";
        }
        return p.isImportant() ? PRIORITY_IMPORTANT : "";
    }

    @Override
    public void setProperty(String propertyName, String value, String priority) throws DOMException {
        try {
            CSSValue expr = null;
            if (!value.isEmpty()) {
                CSSOMParser parser = new CSSOMParser();
                InputSource is = new InputSource(new StringReader(value));
                expr = parser.parsePropertyValue(is);
            }
            Property p = this.getPropertyDeclaration(propertyName);
            boolean important = PRIORITY_IMPORTANT.equalsIgnoreCase(priority);
            if (p == null) {
                p = new Property(propertyName, expr, important);
                this.addProperty(p);
            } else {
                p.setValue(expr);
                p.setImportant(important);
            }
        }
        catch (Exception e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
    }

    @Override
    public int getLength() {
        return this.properties_.size();
    }

    @Override
    public String item(int index) {
        Property p = this.properties_.get(index);
        return p == null ? "" : p.getName();
    }

    @Override
    public CSSRule getParentRule() {
        return this.parentRule_;
    }

    public void addProperty(Property p) {
        if (null == p) {
            return;
        }
        this.properties_.add(p);
    }

    public Property getPropertyDeclaration(String propertyName) {
        if (null == propertyName) {
            return null;
        }
        for (int i = this.properties_.size() - 1; i > -1; --i) {
            Property p = this.properties_.get(i);
            if (p == null || !propertyName.equalsIgnoreCase(p.getName())) continue;
            return p;
        }
        return null;
    }

    public String toString() {
        return this.getCssText();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CSSStyleDeclaration)) {
            return false;
        }
        CSSStyleDeclaration csd = (CSSStyleDeclaration)obj;
        return this.equalsProperties(csd);
    }

    private boolean equalsProperties(CSSStyleDeclaration csd) {
        if (csd == null || this.getLength() != csd.getLength()) {
            return false;
        }
        for (int i = 0; i < this.getLength(); ++i) {
            String propertyPriority2;
            String propertyValue2;
            String propertyName = this.item(i);
            String propertyValue1 = this.getPropertyValue(propertyName);
            if (!LangUtils.equals(propertyValue1, propertyValue2 = csd.getPropertyValue(propertyName))) {
                return false;
            }
            String propertyPriority1 = this.getPropertyPriority(propertyName);
            if (LangUtils.equals(propertyPriority1, propertyPriority2 = csd.getPropertyPriority(propertyName))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 17;
        hash = LangUtils.hashCode(hash, this.properties_);
        return hash;
    }
}

