/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.jetty7.servlets;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.seleniumhq.jetty7.http.gzip.GzipResponseWrapper;
import org.seleniumhq.jetty7.http.gzip.GzipStream;
import org.seleniumhq.jetty7.io.UncheckedPrintWriter;
import org.seleniumhq.jetty7.servlets.GzipFilter;

public class IncludableGzipFilter
extends GzipFilter {
    boolean _uncheckedPrintWriter = false;

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        String tmp = filterConfig.getInitParameter("uncheckedPrintWriter");
        if (tmp != null) {
            this._uncheckedPrintWriter = Boolean.valueOf(tmp);
        }
    }

    protected GzipResponseWrapper newGzipResponseWrapper(HttpServletRequest request, HttpServletResponse response) {
        return new IncludableResponseWrapper(request, response);
    }

    protected PrintWriter newWriter(OutputStream out, String encoding) throws UnsupportedEncodingException {
        if (this._uncheckedPrintWriter) {
            return encoding == null ? new UncheckedPrintWriter(out) : new UncheckedPrintWriter(new OutputStreamWriter(out, encoding));
        }
        return super.newWriter(out, encoding);
    }

    public class IncludableGzipStream
    extends GzipStream {
        public IncludableGzipStream(HttpServletRequest request, HttpServletResponse response, long contentLength, int bufferSize, int minGzipSize) throws IOException {
            super(request, response, contentLength, bufferSize, minGzipSize);
        }

        protected boolean setContentEncodingGzip() {
            if (this._request.getAttribute("javax.servlet.include.request_uri") != null) {
                this._response.setHeader("org.seleniumhq.jetty7.server.include.Content-Encoding", "gzip");
            } else {
                this._response.setHeader("Content-Encoding", "gzip");
            }
            return this._response.containsHeader("Content-Encoding");
        }
    }

    public class IncludableResponseWrapper
    extends GzipResponseWrapper {
        public IncludableResponseWrapper(HttpServletRequest request, HttpServletResponse response) {
            super(request, response);
            super.setMimeTypes(IncludableGzipFilter.this._mimeTypes);
            super.setBufferSize(IncludableGzipFilter.this._bufferSize);
            super.setMinGzipSize(IncludableGzipFilter.this._minGzipSize);
        }

        protected GzipStream newGzipStream(HttpServletRequest request, HttpServletResponse response, long contentLength, int bufferSize, int minGzipSize) throws IOException {
            return new IncludableGzipStream(request, response, contentLength, bufferSize, minGzipSize);
        }

        protected PrintWriter newWriter(OutputStream out, String encoding) throws UnsupportedEncodingException {
            return IncludableGzipFilter.this.newWriter(out, encoding);
        }
    }
}

