/*
 * Decompiled with CFR 0.152.
 */
package cybervillains.ca;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.x509.X509V3CertificateGenerator;
import org.bouncycastle.x509.extension.SubjectKeyIdentifierStructure;

public class CertificateCreator {
    public static final String SIGN_ALGO = "SHA1withRSA";

    public static X509Certificate createTypicalMasterCert(KeyPair keyPair) throws SignatureException, InvalidKeyException, SecurityException, CertificateException, NoSuchAlgorithmException, NoSuchProviderException {
        X509V3CertificateGenerator v3CertGen = new X509V3CertificateGenerator();
        X509Principal issuer = new X509Principal("O=CyberVillians.com,OU=CyberVillians Certification Authority,C=US");
        v3CertGen.setSerialNumber(BigInteger.valueOf(1L));
        v3CertGen.setIssuerDN(issuer);
        v3CertGen.setSubjectDN(issuer);
        v3CertGen.setNotBefore(new Date(System.currentTimeMillis() - 31104000000L));
        v3CertGen.setNotAfter(new Date(System.currentTimeMillis() + 622080000000L));
        v3CertGen.setPublicKey(keyPair.getPublic());
        v3CertGen.setSignatureAlgorithm(SIGN_ALGO);
        v3CertGen.addExtension((DERObjectIdentifier)X509Extensions.SubjectKeyIdentifier, false, (ASN1Encodable)new SubjectKeyIdentifierStructure(keyPair.getPublic()));
        v3CertGen.addExtension((DERObjectIdentifier)X509Extensions.BasicConstraints, true, (ASN1Encodable)new BasicConstraints(0));
        v3CertGen.addExtension((DERObjectIdentifier)X509Extensions.KeyUsage, false, (ASN1Encodable)new KeyUsage(6));
        DERSequence typicalCAExtendedKeyUsages = new DERSequence(new ASN1Encodable[]{new DERObjectIdentifier("1.3.6.1.5.5.7.3.1"), new DERObjectIdentifier("1.3.6.1.5.5.7.3.9"), new DERObjectIdentifier("2.16.840.1.113733.1.8.1")});
        v3CertGen.addExtension((DERObjectIdentifier)X509Extensions.ExtendedKeyUsage, false, (ASN1Encodable)typicalCAExtendedKeyUsages);
        X509Certificate cert = v3CertGen.generate(keyPair.getPrivate(), "BC");
        cert.checkValidity(new Date());
        cert.verify(keyPair.getPublic());
        return cert;
    }
}

