/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.opera.core.systems.EmulationProfile;
import com.opera.core.systems.OperaArguments;
import com.opera.core.systems.OperaBinary;
import com.opera.core.systems.OperaDriver;
import com.opera.core.systems.OperaLogs;
import com.opera.core.systems.OperaProduct;
import com.opera.core.systems.OperaProfile;
import com.opera.core.systems.arguments.OperaArgument;
import com.opera.core.systems.arguments.OperaCoreArguments;
import com.opera.core.systems.arguments.OperaDesktopArguments;
import com.opera.core.systems.common.lang.OperaBoolean;
import com.opera.core.systems.mobile.MobileDevices;
import com.opera.core.systems.runner.OperaRunner;
import com.opera.core.systems.runner.launcher.OperaLauncherRunner;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.json.JSONException;
import org.json.JSONObject;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Platform;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.net.PortProber;
import org.openqa.selenium.remote.DesiredCapabilities;

public class OperaSettings {
    private final Map<Capability, CapabilityInstance> options = Maps.newHashMap();
    private final DesiredCapabilities surplusCapabilities = new DesiredCapabilities();
    private final OperaLogging logging = new OperaLogging();
    private boolean supportsPd = true;

    public OperaSettings() {
        for (Capability capability : Capability.values()) {
            this.options.put(capability, new CapabilityInstance(capability));
        }
        this.initializeLogging();
    }

    public OperaSettings(OperaProfile profile) {
        this();
        this.setProfile(profile);
    }

    public OperaLogging logging() {
        return this.logging;
    }

    public File getBinary() {
        return (File)this.options.get((Object)Capability.BINARY).getValue();
    }

    public void setBinary(File binary) {
        this.options.get((Object)Capability.BINARY).setValue(Capability.BINARY.sanitize(binary));
    }

    public OperaArguments arguments() {
        return (OperaArguments)this.options.get((Object)Capability.ARGUMENTS).getValue();
    }

    public String getHost() {
        return (String)this.options.get((Object)Capability.HOST).getValue();
    }

    public void setHost(String ip) {
        this.options.get((Object)Capability.HOST).setValue(ip);
    }

    public int getPort() {
        return (Integer)this.options.get((Object)Capability.PORT).getValue();
    }

    public void setPort(int port) {
        this.options.get((Object)Capability.PORT).setValue(Capability.PORT.sanitize(String.valueOf(port)));
    }

    public File getLauncher() {
        if (System.getenv("OPERA_LAUNCHER") != null && !System.getenv("OPERA_LAUNCHER").isEmpty()) {
            this.options.get((Object)Capability.LAUNCHER).setValue(new File(System.getenv("OPERA_LAUNCHER")));
        }
        return (File)this.options.get((Object)Capability.LAUNCHER).getValue();
    }

    public void setLauncher(File launcherBinary) throws IOException {
        OperaLauncherRunner.assertLauncherGood(launcherBinary);
        this.options.get((Object)Capability.LAUNCHER).setValue(launcherBinary);
    }

    public OperaProfile profile() {
        return (OperaProfile)this.options.get((Object)Capability.PROFILE).getValue();
    }

    public void setProfile(String profileDirectory) {
        this.options.get((Object)Capability.PROFILE).setValue(Capability.PROFILE.sanitize(profileDirectory));
        this.supportsPd = profileDirectory == null || !profileDirectory.isEmpty();
    }

    public void setProfile(OperaProfile profile) {
        this.options.get((Object)Capability.PROFILE).setValue(Capability.PROFILE.sanitize(profile));
        this.supportsPd = true;
    }

    public boolean useIdle() {
        return (Boolean)this.options.get((Object)Capability.OPERAIDLE).getValue();
    }

    public void setIdle(boolean enabled) {
        this.options.get((Object)Capability.OPERAIDLE).setValue(enabled);
    }

    public Integer getDisplay() {
        return (Integer)this.options.get((Object)Capability.DISPLAY).getValue();
    }

    public void setDisplay(int display) {
        if (!Platform.getCurrent().is(Platform.LINUX)) {
            throw new UnsupportedOperationException("Unsupported platform: " + (Object)((Object)Platform.getCurrent()));
        }
        this.options.get((Object)Capability.DISPLAY).setValue(display);
    }

    public boolean autostart() {
        return (Boolean)this.options.get((Object)Capability.AUTOSTART).getValue();
    }

    public void autostart(boolean enabled) {
        this.options.get((Object)Capability.AUTOSTART).setValue(enabled);
        if (!enabled) {
            this.setPort(-1);
        }
    }

    public Proxy getProxy() {
        return (Proxy)this.options.get((Object)Capability.PROXY).getValue();
    }

    public void setProxy(Proxy proxy) {
        this.options.get((Object)Capability.PROXY).setValue(proxy);
    }

    public OperaProduct getProduct() {
        return (OperaProduct)((Object)this.options.get((Object)Capability.PRODUCT).getValue());
    }

    public void setProduct(OperaProduct product) {
        this.options.get((Object)Capability.PRODUCT).setValue((Object)product);
        OperaCoreArguments arguments = this.getProduct().is(OperaProduct.DESKTOP) ? new OperaDesktopArguments() : new OperaCoreArguments();
        this.options.get((Object)Capability.ARGUMENTS).setValue(arguments.merge(this.arguments()));
    }

    public OperaRunner getRunner() {
        OperaRunner runner;
        Constructor<?> constructor;
        Class<?> klass;
        String klassName = (String)this.options.get((Object)Capability.RUNNER).getValue();
        if (klassName == null) {
            this.setRunner(OperaLauncherRunner.class);
            return this.getRunner();
        }
        try {
            klass = Class.forName(klassName);
        }
        catch (ClassNotFoundException e) {
            throw new WebDriverException("Unable to find runner class on classpath: " + klassName);
        }
        try {
            constructor = klass.getDeclaredConstructor(OperaSettings.class);
        }
        catch (NoSuchMethodException e) {
            throw new WebDriverException("Invalid constructor in runner: " + klass.getName());
        }
        try {
            runner = (OperaRunner)constructor.newInstance(this);
        }
        catch (InstantiationException e) {
            throw new WebDriverException("Unable to create new instance of runner", e);
        }
        catch (IllegalAccessException e) {
            throw new WebDriverException("Denied access to runner: " + klass.getName());
        }
        catch (InvocationTargetException e) {
            throw new WebDriverException("Runner threw exception on construction", e);
        }
        return runner;
    }

    public void setRunner(Class<? extends OperaRunner> runner) {
        this.options.get((Object)Capability.RUNNER).setValue(runner.getName());
    }

    @Deprecated
    public boolean noRestart() {
        return (Boolean)this.options.get((Object)Capability.NO_RESTART).getValue();
    }

    @Deprecated
    public void noRestart(boolean enabled) {
        this.options.get((Object)Capability.NO_RESTART).setValue(enabled);
    }

    public boolean hasDetach() {
        return (Boolean)this.options.get((Object)Capability.DETACH).getValue();
    }

    public void setDetach(boolean enabled) {
        this.options.get((Object)Capability.DETACH).setValue(enabled);
    }

    public EmulationProfile getEmulationProfile() {
        return (EmulationProfile)this.options.get((Object)Capability.EMULATION_PROFILE).getValue();
    }

    public void emulate(MobileDevices device) {
        this.emulate(device.getProfile());
    }

    public void emulate(EmulationProfile profile) {
        this.options.get((Object)Capability.EMULATION_PROFILE).setValue(profile);
        if (profile != null) {
            Dimension resolution = profile.getResolution();
            this.arguments().add("-windowsize", String.format("%dx%d", resolution.getWidth(), resolution.getHeight()));
            this.arguments().add(new OperaArgument("-ppi", profile.getPPI()));
            if (profile.getIME() == EmulationProfile.IME.KEYPAD) {
                this.arguments().add("-notouchwithtouchevents");
            } else if (profile.getIME() == EmulationProfile.IME.TABLET) {
                this.arguments().add(new OperaArgument("-tabletui"));
            }
            this.arguments().add("-user-agent-string", profile.getUserAgent());
            this.arguments().add(new OperaArgument("-profile-name", profile.getProfileName()));
        }
    }

    @Deprecated
    public String getBackend() {
        return (String)this.options.get((Object)Capability.BACKEND).getValue();
    }

    @Deprecated
    public void setBackend(String backend) {
        this.options.get((Object)Capability.BACKEND).setValue(backend);
    }

    public boolean supportsDebugProxy() {
        return this.getPort() != 7001;
    }

    public boolean supportsPd() {
        return !this.getProduct().is(OperaProduct.CORE) && this.supportsPd;
    }

    public OperaSettings merge(Capabilities capabilities) {
        for (Map.Entry<String, ?> capability : capabilities.asMap().entrySet()) {
            Capability capabilityReference = Capability.findCapability(capability.getKey());
            if (this.options.containsKey((Object)capabilityReference)) {
                this.options.get((Object)capabilityReference).setValue(capabilityReference.sanitize(capability.getValue()));
                continue;
            }
            this.surplusCapabilities.setCapability(capability.getKey(), capability.getValue());
        }
        this.initializeLogging();
        return this;
    }

    public Capabilities toCapabilities() {
        DesiredCapabilities capabilities = DesiredCapabilities.opera();
        for (CapabilityInstance option : this.options.values()) {
            if (option.getValue() == null) continue;
            capabilities.setCapability(option.getCapability(), option.getValue());
        }
        return capabilities.merge(this.surplusCapabilities);
    }

    public JSONObject toJson() throws IOException, JSONException {
        JSONObject json = new JSONObject();
        for (CapabilityInstance option : this.options.values()) {
            Object value = option.getValue();
            if (value == null) continue;
            value = value instanceof OperaProfile ? ((OperaProfile)value).toJson() : (value instanceof OperaArguments && ((OperaArguments)value).size() > 0 ? ((OperaArguments)value).toJson() : (value instanceof Boolean ? Integer.valueOf((Boolean)value != false ? 1 : 0) : String.valueOf(value)));
            json.put(option.getIdentifier(), value);
        }
        return json;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof OperaSettings)) {
            return false;
        }
        OperaSettings compareTo = (OperaSettings)o;
        for (Map.Entry<Capability, CapabilityInstance> entry : this.options.entrySet()) {
            if (compareTo.options.get((Object)entry.getKey()).equals(entry.getValue())) continue;
            return false;
        }
        for (Map.Entry<Object, CapabilityInstance> entry : this.surplusCapabilities.asMap().entrySet()) {
            if (compareTo.surplusCapabilities.getCapability((String)entry.getKey()).equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return String.format("OperaSettings %s", this.options.values());
    }

    private void initializeLogging() {
        this.logging().setLevel(this.logging().getLevel());
        this.logging().setFile(this.logging().getFile());
    }

    public static class Builder {
        private final OperaSettings settings = new OperaSettings();

        public Builder usingProfile(OperaProfile profile) {
            this.settings.setProfile(profile);
            return this;
        }

        public Builder product(OperaProduct product) {
            this.settings.setProduct(product);
            return this;
        }

        public OperaSettings get() {
            return this.settings;
        }
    }

    public class OperaLogging {
        public Level getLevel() {
            return (Level)((CapabilityInstance)OperaSettings.this.options.get((Object)Capability.LOGGING_LEVEL)).getValue();
        }

        public void setLevel(Level level) {
            Preconditions.checkNotNull(level);
            ((CapabilityInstance)OperaSettings.this.options.get((Object)Capability.LOGGING_LEVEL)).setValue(level);
            Logger root = Logger.getLogger(OperaDriver.class.getPackage().getName());
            if (!Iterators.any(Arrays.asList(root.getHandlers()).iterator(), new Predicate<Handler>(){

                @Override
                public boolean apply(Handler handler) {
                    return handler instanceof ConsoleHandler;
                }
            })) {
                root.addHandler(new ConsoleHandler());
            }
            if (!Iterators.any(Arrays.asList(root.getHandlers()).iterator(), new Predicate<Handler>(){

                @Override
                public boolean apply(Handler handler) {
                    return handler instanceof OperaLogs.DriverLogsHandler;
                }
            })) {
                root.addHandler(new OperaLogs.DriverLogsHandler(OperaDriver.logs));
            }
            root.setLevel(level);
            root.setUseParentHandlers(false);
            for (Handler handler : root.getHandlers()) {
                if (handler instanceof OperaLogs.DriverLogsHandler) {
                    handler.setLevel(Level.ALL);
                    continue;
                }
                handler.setLevel(level);
            }
        }

        public File getFile() {
            return (File)((CapabilityInstance)OperaSettings.this.options.get((Object)Capability.LOGGING_FILE)).getValue();
        }

        public void setFile(File file) {
            ((CapabilityInstance)OperaSettings.this.options.get((Object)Capability.LOGGING_FILE)).setValue(file);
            if (file != null) {
                FileHandler logFile;
                try {
                    logFile = new FileHandler(file.getPath(), true);
                    logFile.setFormatter(new SimpleFormatter());
                }
                catch (IOException e) {
                    throw new WebDriverException("Unable to write to log file: " + e.getMessage(), e);
                }
                logFile.setLevel(this.getLevel());
                Logger.getLogger(OperaDriver.class.getPackage().getName()).addHandler(logFile);
                OperaDriver.logFile = logFile;
            }
        }
    }

    private class CapabilityInstance {
        private final String identifier;
        private final String capabilityName;
        private Object value = null;

        public CapabilityInstance(Capability capability) {
            this.identifier = capability.getIdentifier();
            this.capabilityName = capability.getCapability();
            this.value = capability.getDefaultValue();
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final String getCapability() {
            return this.capabilityName;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public String toString() {
            return String.format("%s=%s", this.getIdentifier(), this.getValue());
        }
    }

    public static enum Capability {
        LOGGING_LEVEL("opera.logging.level"){

            @Override
            Level getDefaultValue() {
                return Level.INFO;
            }

            @Override
            Object sanitize(Object value) {
                if (value == null || value instanceof Level) {
                    return value;
                }
                return Level.parse(String.valueOf(value).toUpperCase());
            }
        }
        ,
        LOGGING_FILE("opera.logging.file"){

            @Override
            Object sanitize(Object path) {
                if (path != null && path instanceof String) {
                    return new File(String.valueOf(path));
                }
                return path;
            }
        }
        ,
        BINARY{

            @Override
            Object sanitize(Object binary) {
                if (binary == null) {
                    return binary;
                }
                if (binary instanceof String) {
                    return new OperaBinary(String.valueOf(binary)).getFile();
                }
                if (binary instanceof File) {
                    return new OperaBinary((File)binary).getFile();
                }
                throw new IllegalArgumentException("Unknown type: " + binary.getClass().getSimpleName());
            }
        }
        ,
        ARGUMENTS{

            @Override
            OperaArguments getDefaultValue() {
                return new OperaCoreArguments();
            }

            @Override
            OperaArguments sanitize(Object arguments) {
                if (arguments instanceof String) {
                    return new OperaArguments(String.valueOf(arguments));
                }
                if (arguments instanceof OperaArguments) {
                    return (OperaArguments)arguments;
                }
                return new OperaArguments();
            }
        }
        ,
        HOST{

            @Override
            String getDefaultValue() {
                return "127.0.0.1";
            }

            @Override
            Object sanitize(Object host) {
                if (host == null) {
                    return host;
                }
                return String.valueOf(host);
            }
        }
        ,
        PORT{

            @Override
            Integer getDefaultValue() {
                return PortProber.findFreePort();
            }

            @Override
            Integer sanitize(Object value) {
                Preconditions.checkNotNull(value);
                int port = Integer.valueOf(String.valueOf(value));
                if (port == 0) {
                    port = PortProber.findFreePort();
                } else if (port == -1) {
                    port = 7001;
                }
                return port;
            }
        }
        ,
        LAUNCHER{

            @Override
            File getDefaultValue() {
                if (System.getenv("OPERA_LAUNCHER") != null && !System.getenv("OPERA_LAUNCHER").isEmpty()) {
                    return new File(System.getenv("OPERA_LAUNCHER"));
                }
                return OperaLauncherRunner.LAUNCHER_DEFAULT_LOCATION;
            }

            @Override
            Object sanitize(Object path) {
                if (path != null) {
                    return new File(String.valueOf(path));
                }
                return path;
            }
        }
        ,
        PROFILE{

            @Override
            OperaProfile getDefaultValue() {
                return new OperaProfile();
            }

            @Override
            Object sanitize(Object value) {
                Preconditions.checkNotNull(value);
                if (value instanceof String && String.valueOf(value) != null) {
                    String profileDirectory = String.valueOf(value);
                    if (!profileDirectory.isEmpty()) {
                        return new OperaProfile(profileDirectory);
                    }
                } else {
                    Map map;
                    if (value instanceof OperaProfile) {
                        return value;
                    }
                    if (value instanceof Map && (map = (Map)value).containsKey("base64")) {
                        try {
                            return OperaProfile.fromJson((String)map.get("base64"));
                        }
                        catch (IOException e) {
                            throw new WebDriverException(e);
                        }
                    }
                }
                return new OperaProfile();
            }
        }
        ,
        OPERAIDLE("opera.idle"){

            @Override
            Boolean getDefaultValue() {
                return false;
            }

            @Override
            Boolean sanitize(Object enabled) {
                Preconditions.checkNotNull(enabled);
                return OperaBoolean.parseBoolean(String.valueOf(enabled));
            }
        }
        ,
        DISPLAY{

            @Override
            Integer sanitize(Object display) {
                Preconditions.checkNotNull(display);
                return Integer.parseInt(String.valueOf(display));
            }
        }
        ,
        AUTOSTART{

            @Override
            Boolean getDefaultValue() {
                return true;
            }

            @Override
            Boolean sanitize(Object enabled) {
                Preconditions.checkNotNull(enabled);
                return OperaBoolean.parseBoolean(String.valueOf(enabled));
            }
        }
        ,
        PROXY("proxy"){

            @Override
            Proxy getDefaultValue() {
                return new Proxy();
            }

            @Override
            Proxy sanitize(Object proxy) {
                if (proxy != null) {
                    if (proxy instanceof Proxy) {
                        return (Proxy)proxy;
                    }
                    if (proxy instanceof Map) {
                        return new Proxy((Map)proxy);
                    }
                }
                return null;
            }
        }
        ,
        RUNNER("opera.runner"){

            @Override
            String getDefaultValue() {
                return OperaLauncherRunner.class.getName();
            }

            @Override
            Class sanitize(Object runner) {
                if (runner instanceof Class) {
                    return (Class)runner;
                }
                if (runner instanceof String) {
                    try {
                        return Class.forName(String.valueOf(runner));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                throw new WebDriverException("Unknown runner: " + runner);
            }
        }
        ,
        EMULATION_PROFILE("opera.emulationProfile"){

            @Override
            EmulationProfile sanitize(Object config) {
                if (config instanceof String) {
                    return MobileDevices.find(String.valueOf(config)).getProfile();
                }
                if (config instanceof EmulationProfile) {
                    return (EmulationProfile)config;
                }
                if (config instanceof MobileDevices) {
                    return ((MobileDevices)((Object)config)).getProfile();
                }
                return null;
            }
        }
        ,
        NO_RESTART{

            @Override
            Boolean getDefaultValue() {
                return false;
            }

            @Override
            Boolean sanitize(Object enabled) {
                Preconditions.checkNotNull(enabled);
                return OperaBoolean.parseBoolean(String.valueOf(enabled));
            }
        }
        ,
        NO_QUIT{

            @Override
            Boolean getDefaultValue() {
                return (Boolean)DETACH.getDefaultValue();
            }

            @Override
            Boolean sanitize(Object enabled) {
                return (Boolean)DETACH.sanitize(enabled);
            }
        }
        ,
        DETACH{

            @Override
            Boolean getDefaultValue() {
                return false;
            }

            @Override
            Boolean sanitize(Object enabled) {
                Preconditions.checkNotNull(enabled);
                return OperaBoolean.parseBoolean(String.valueOf(enabled));
            }
        }
        ,
        PRODUCT{

            OperaProduct getDefaultValue() {
                return OperaProduct.DESKTOP;
            }

            OperaProduct sanitize(Object product) {
                if (product == null) {
                    return null;
                }
                if (product instanceof OperaProduct) {
                    return (OperaProduct)((Object)product);
                }
                return OperaProduct.get(String.valueOf(product));
            }
        }
        ,
        BACKEND{

            @Override
            String getDefaultValue() {
                return "software";
            }

            @Override
            Object sanitize(Object backend) {
                return backend;
            }
        };

        private static final String CAPABILITY_PREFIX = "opera.";
        private static final ImmutableMap<String, Capability> lookup;
        private final String identifier = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, this.name());
        private final String capability;

        private Capability() {
            this.capability = CAPABILITY_PREFIX + this.name().toLowerCase();
        }

        private Capability(String capabilityName) {
            this.capability = capabilityName;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public String getCapability() {
            return this.capability;
        }

        Object getDefaultValue() {
            return null;
        }

        Object sanitize(Object value) {
            Preconditions.checkNotNull(value);
            return value;
        }

        public String toString() {
            return this.getCapability();
        }

        public static Capability findCapability(String capabilityName) {
            return lookup.get(capabilityName);
        }

        static {
            ImmutableMap.Builder<String, Capability> builder = ImmutableMap.builder();
            for (Capability capability : Capability.values()) {
                builder.put(capability.getCapability(), capability);
            }
            lookup = builder.build();
        }
    }
}

