/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.openqa.selenium.WebDriverException;

public class OperaExtensions {
    private File directory;
    private File widgetsDat;
    private File backupWidgetDat;
    private static final String WUID_PREFIX = "wuid-operadriver-";
    private static final String OEX_PATH_PREFIX = "operadriver-";
    private static final String WIDGET_DAT_CONTENT = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<preferences>\n</preferences>\n";
    private static final String WIDGET_DAT_ITEM = "  <section id=\"%s\">\n    <value id=\"path to widget data\" xml:space=\"preserve\">%s</value>\n    <value id=\"download_URL\" null=\"yes\"/>\n    <value id=\"content-type\" xml:space=\"preserve\">3</value>\n    <value id=\"class state\" xml:space=\"preserve\">enabled</value>\n  </section>\n";
    private static final String WIDGET_PREFS_DAT_CONTENT = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<preferences>\n  <section id=\"ui\">\n    <value id=\"default-prefs-applied\" xml:space=\"preserve\">1</value>\n  </section>\n  <section id=\"%s\">\n    <value id=\"network_access\" xml:space=\"preserve\">24</value>\n  </section>\n  <section id=\"user\">\n    <value id=\"GadgetRunOnSecureConn\" xml:space=\"preserve\">yes</value>\n    <value id=\"GadgetEnabledOnStartup\" xml:space=\"preserve\">yes</value>\n  </section>\n</preferences>\n";

    OperaExtensions(File profileDirectory) {
        this.directory = new File(profileDirectory, "widgets");
        this.widgetsDat = new File(this.directory, "widgets.dat");
        if (this.widgetsDat.exists()) {
            try {
                this.backupWidgetDat = File.createTempFile(OEX_PATH_PREFIX, "-widgets.dat");
                Files.copy(this.widgetsDat, this.backupWidgetDat);
            }
            catch (IOException e) {
                throw new WebDriverException("Unable to create a back-up of " + this.widgetsDat.getPath());
            }
        }
    }

    public void addExtension(File extensionToInstall) throws IOException {
        this.verifyPathIsOEX(extensionToInstall);
        this.createInitialDirectoryIfNecessary();
        String wuid = WUID_PREFIX + UUID.randomUUID().toString();
        File oexfile = File.createTempFile(OEX_PATH_PREFIX, extensionToInstall.getName(), this.directory);
        Files.copy(extensionToInstall, oexfile);
        this.writeOEXtoWidgetsDat(wuid, oexfile);
        this.createOEXDirectory(wuid);
    }

    public void cleanUp() {
        if (this.backupWidgetDat != null) {
            try {
                Files.move(this.backupWidgetDat, this.widgetsDat);
            }
            catch (IOException e) {
                throw new WebDriverException("Unable to restore widgets.dat");
            }
        } else {
            this.widgetsDat.delete();
        }
    }

    private void verifyPathIsOEX(File path) {
        Preconditions.checkNotNull(path);
        Preconditions.checkArgument(path.exists(), "%s does not exist", path.getAbsolutePath());
        Preconditions.checkArgument(!path.isDirectory(), "%s is a directory", path.getAbsolutePath());
        Preconditions.checkArgument(path.getName().endsWith(".oex"), "%s does not end with .oex", path.getName());
    }

    private void createInitialDirectoryIfNecessary() throws IOException {
        if (!this.directory.exists() && !this.directory.mkdirs()) {
            throw new WebDriverException("Unable to create directory path: " + this.directory.getPath());
        }
        if (!this.widgetsDat.exists()) {
            Files.write(WIDGET_DAT_CONTENT, this.widgetsDat, Charsets.UTF_8);
        }
    }

    private void writeOEXtoWidgetsDat(String wuid, File oexpath) throws IOException {
        String oexpathRelative = "{LargePreferences}widgets/" + oexpath.getName();
        String widgetString = Files.toString(this.widgetsDat, Charsets.UTF_8);
        int beforePreferencesEndTag = widgetString.lastIndexOf("</preferences>");
        if (beforePreferencesEndTag == -1) {
            throw new WebDriverException("</preferences> not found in " + this.widgetsDat.getPath());
        }
        String widgetDatSection = String.format(WIDGET_DAT_ITEM, wuid, oexpathRelative);
        widgetString = widgetString.substring(0, beforePreferencesEndTag) + widgetDatSection + widgetString.substring(beforePreferencesEndTag);
        Files.write(widgetString, this.widgetsDat, Charsets.UTF_8);
    }

    private void createOEXDirectory(String wuid) throws IOException {
        File oexDirectory = new File(this.directory, wuid);
        if (!oexDirectory.exists() && !oexDirectory.mkdirs()) {
            throw new WebDriverException("Unable to create directory path: " + this.directory.getPath());
        }
        File prefsDatPath = new File(oexDirectory, "prefs.dat");
        String prefContent = String.format(WIDGET_PREFS_DAT_CONTENT, wuid);
        Files.write(prefContent, prefsDatPath, Charsets.UTF_8);
    }
}

