/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClasses;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import net.sourceforge.htmlunit.corejs.javascript.Context;

@JsxClasses(isJSObject=false)
public class HTMLListElement
extends HTMLElement {
    @JsxGetter
    public boolean getCompact() {
        return this.getDomNodeOrDie().hasAttribute("compact");
    }

    @JsxSetter
    public void setCompact(Object compact) {
        if (Context.toBoolean(compact)) {
            this.getDomNodeOrDie().setAttribute("compact", "");
        } else {
            this.getDomNodeOrDie().removeAttribute("compact");
        }
    }

    @Override
    public Object getAttribute(String attributeName, Integer flags) {
        if ("compact".equals(attributeName) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLLIST_LIMIT_COMPACT_TO_BOOLEAN)) {
            return this.getCompact();
        }
        return super.getAttribute(attributeName, flags);
    }

    protected String getType() {
        boolean acceptArbitraryValues = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_TYPE_ACCEPTS_ARBITRARY_VALUES);
        String type = this.getDomNodeOrDie().getAttribute("type");
        if (acceptArbitraryValues || "1".equals(type) || "a".equals(type) || "A".equals(type) || "i".equals(type) || "I".equals(type)) {
            return type;
        }
        return "";
    }

    protected void setType(String type) {
        boolean acceptArbitraryValues = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_TYPE_ACCEPTS_ARBITRARY_VALUES);
        if (acceptArbitraryValues || "1".equals(type) || "a".equals(type) || "A".equals(type) || "i".equals(type) || "I".equals(type)) {
            this.getDomNodeOrDie().setAttribute("type", type);
            return;
        }
        throw Context.reportRuntimeError("Cannot set the type property to invalid value: '" + type + "'");
    }
}

