/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.FormFieldWithNameHistory;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeEvent;
import com.gargoylesoftware.htmlunit.html.HtmlButton;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlImage;
import com.gargoylesoftware.htmlunit.html.HtmlImageInput;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlSelect;
import com.gargoylesoftware.htmlunit.html.HtmlTextArea;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Event;
import com.gargoylesoftware.htmlunit.javascript.host.NodeList;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCollection;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import org.apache.commons.lang3.StringUtils;

@JsxClass(domClasses={HtmlForm.class})
public class HTMLFormElement
extends HTMLElement
implements Function {
    private HTMLCollection elements_;

    @Override
    public void setHtmlElement(HtmlElement htmlElement) {
        super.setHtmlElement(htmlElement);
        HtmlForm htmlForm = this.getHtmlForm();
        htmlForm.setScriptObject(this);
    }

    @JsxGetter
    public String getName() {
        return this.getHtmlForm().getNameAttribute();
    }

    @JsxSetter
    public void setName(String name) {
        WebAssert.notNull("name", name);
        this.getHtmlForm().setNameAttribute(name);
    }

    @JsxGetter
    public HTMLCollection getElements() {
        if (this.elements_ == null) {
            final HtmlForm htmlForm = this.getHtmlForm();
            this.elements_ = new HTMLCollection(htmlForm, false, "HTMLFormElement.elements"){
                private boolean filterChildrenOfNestedForms_;

                @Override
                protected List<Object> computeElements() {
                    List<Object> response = super.computeElements();
                    if (this.filterChildrenOfNestedForms_) {
                        Iterator<Object> iter = response.iterator();
                        while (iter.hasNext()) {
                            HtmlElement field = (HtmlElement)iter.next();
                            if (field.getEnclosingForm() == htmlForm) continue;
                            iter.remove();
                        }
                    }
                    response.addAll(htmlForm.getLostChildren());
                    return response;
                }

                @Override
                protected Object getWithPreemption(String name) {
                    return HTMLFormElement.this.getWithPreemption(name);
                }

                @Override
                public NodeList.EffectOnCache getEffectOnCache(HtmlAttributeChangeEvent event) {
                    return NodeList.EffectOnCache.NONE;
                }

                @Override
                protected boolean isMatching(DomNode node) {
                    if (node instanceof HtmlForm) {
                        this.filterChildrenOfNestedForms_ = true;
                        return false;
                    }
                    return node instanceof HtmlInput || node instanceof HtmlButton || node instanceof HtmlTextArea || node instanceof HtmlSelect;
                }
            };
        }
        return this.elements_;
    }

    @JsxGetter
    public int getLength() {
        int all = this.getElements().getLength();
        int images = this.getHtmlForm().getElementsByAttribute("input", "type", "image").size();
        return all - images;
    }

    @JsxGetter
    public String getAction() {
        String action = this.getHtmlForm().getActionAttribute();
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_169)) {
            try {
                action = ((HtmlPage)this.getHtmlForm().getPage()).getFullyQualifiedUrl(action).toExternalForm();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return action;
    }

    @JsxSetter
    public void setAction(String action) {
        WebAssert.notNull("action", action);
        this.getHtmlForm().setActionAttribute(action);
    }

    @JsxGetter
    public String getMethod() {
        return this.getHtmlForm().getMethodAttribute();
    }

    @JsxSetter
    public void setMethod(String method) {
        WebAssert.notNull("method", method);
        this.getHtmlForm().setMethodAttribute(method);
    }

    @JsxGetter
    public String getTarget() {
        return this.getHtmlForm().getTargetAttribute();
    }

    @Override
    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public Object getOnsubmit() {
        return this.getEventHandlerProp("onsubmit");
    }

    @Override
    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setOnsubmit(Object onsubmit) {
        this.setEventHandlerProp("onsubmit", onsubmit);
    }

    @JsxSetter
    public void setTarget(String target) {
        WebAssert.notNull("target", target);
        this.getHtmlForm().setTargetAttribute(target);
    }

    @JsxGetter
    public String getEncoding() {
        String encoding = this.getHtmlForm().getEnctypeAttribute();
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_FORM_ENCODING_NORMALIZED) && !"application/x-www-form-urlencoded".equals(encoding) && !"multipart/form-data".equals(encoding)) {
            return "application/x-www-form-urlencoded";
        }
        return encoding;
    }

    @JsxSetter
    public void setEncoding(String encoding) {
        WebAssert.notNull("encoding", encoding);
        this.getHtmlForm().setEnctypeAttribute(encoding);
    }

    private HtmlForm getHtmlForm() {
        return (HtmlForm)this.getDomNodeOrDie();
    }

    @JsxFunction
    public void submit() {
        HtmlPage page = (HtmlPage)this.getDomNodeOrDie().getPage();
        WebClient webClient = page.getWebClient();
        String action = this.getHtmlForm().getActionAttribute().trim();
        if (StringUtils.startsWithIgnoreCase(action, "javascript:")) {
            String js = action.substring("javascript:".length());
            webClient.getJavaScriptEngine().execute(page, js, "Form action", 0);
        } else {
            WebRequest request = this.getHtmlForm().getWebRequest(null);
            String target = page.getResolvedTarget(this.getTarget());
            boolean isHashJump = HttpMethod.GET == request.getHttpMethod() && action.endsWith("#");
            webClient.download(page.getEnclosingWindow(), target, request, isHashJump, "JS form.submit()");
        }
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public Object item(Object index, Object subIndex) {
        if (index instanceof Number) {
            return this.getElements().item(index);
        }
        String name = Context.toString(index);
        Object response = this.getWithPreemption(name);
        if (subIndex instanceof Number && response instanceof HTMLCollection) {
            return ((HTMLCollection)response).item(subIndex);
        }
        return response;
    }

    @JsxFunction
    public void reset() {
        this.getHtmlForm().reset();
    }

    @Override
    protected Object getWithPreemption(final String name) {
        List<HtmlElement> elements = this.findElements(name);
        if (elements.isEmpty()) {
            return NOT_FOUND;
        }
        if (elements.size() == 1) {
            return this.getScriptableFor(elements.get(0));
        }
        HTMLCollection collection = new HTMLCollection(this.getHtmlForm(), elements){

            @Override
            protected List<Object> computeElements() {
                return new ArrayList<Object>(HTMLFormElement.this.findElements(name));
            }
        };
        return collection;
    }

    private List<HtmlElement> findElements(String name) {
        ArrayList<HtmlElement> elements = new ArrayList<HtmlElement>();
        this.addElements(name, this.getHtmlForm().getHtmlElementDescendants(), elements);
        this.addElements(name, this.getHtmlForm().getLostChildren(), elements);
        if (elements.isEmpty()) {
            for (DomNode node : this.getHtmlForm().getChildren()) {
                HtmlImage img;
                if (!(node instanceof HtmlImage) || !name.equals((img = (HtmlImage)node).getId()) && !name.equals(img.getNameAttribute())) continue;
                elements.add(img);
            }
        }
        return elements;
    }

    private void addElements(String name, Iterable<HtmlElement> nodes, List<HtmlElement> addTo) {
        for (HtmlElement node : nodes) {
            if (!this.isAccessibleByIdOrName(node, name)) continue;
            addTo.add(node);
        }
    }

    private boolean isAccessibleByIdOrName(HtmlElement element, String name) {
        if (element instanceof FormFieldWithNameHistory && !(element instanceof HtmlImageInput)) {
            if (element.getEnclosingForm() != this.getHtmlForm()) {
                return false;
            }
            FormFieldWithNameHistory elementWithNames = (FormFieldWithNameHistory)((Object)element);
            if (name.equals(elementWithNames.getOriginalName()) || name.equals(element.getId())) {
                return true;
            }
            if (!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.FORMFIELD_REACHABLE_BY_NEW_NAMES)) {
                return false;
            }
            if (name.equals(element.getAttribute("name")) || elementWithNames.getPreviousNames().contains(name)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object get(int index, Scriptable start) {
        if (this.getDomNodeOrNull() == null) {
            return NOT_FOUND;
        }
        return this.getElements().get(index, (Scriptable)((HTMLFormElement)start).getElements());
    }

    @Override
    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_80)) {
            throw Context.reportRuntimeError("Not a function.");
        }
        if (args.length > 0) {
            Object arg = args[0];
            if (arg instanceof String) {
                return ScriptableObject.getProperty((Scriptable)this, (String)arg);
            }
            if (arg instanceof Number) {
                return ScriptableObject.getProperty((Scriptable)this, ((Number)arg).intValue());
            }
        }
        return Context.getUndefinedValue();
    }

    @Override
    public Scriptable construct(Context cx, Scriptable scope, Object[] args) {
        if (!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_81)) {
            throw Context.reportRuntimeError("Not a function.");
        }
        return null;
    }

    @Override
    public boolean dispatchEvent(Event event) {
        boolean result = super.dispatchEvent(event);
        if (event.getType().equals("submit")) {
            this.submit();
        }
        return result;
    }
}

