/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.host.HashChangeEvent;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.util.UrlUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@JsxClass
public class Location
extends SimpleScriptable {
    private static final Pattern DECODE_HASH_PATTERN = Pattern.compile("%([\\dA-F]{2})");
    private static final Log LOG = LogFactory.getLog(Location.class);
    private static final String UNKNOWN = "null";
    private Window window_;
    private String hash_;

    public void initialize(Window window) {
        this.window_ = window;
        if (this.window_ != null && this.window_.getWebWindow().getEnclosedPage() != null) {
            this.setHash(this.window_.getWebWindow().getEnclosedPage().getUrl().getRef());
        }
    }

    @Override
    public Object getDefaultValue(Class<?> hint) {
        if (hint == null || String.class.equals(hint)) {
            return this.getHref();
        }
        return super.getDefaultValue(hint);
    }

    @JsxFunction
    public void assign(String url) throws IOException {
        this.setHref(url);
    }

    @JsxFunction
    public void reload(boolean force) throws IOException {
        String url = this.getHref();
        if (UNKNOWN.equals(url)) {
            LOG.error("Unable to reload location: current URL is unknown.");
        } else {
            this.setHref(url);
        }
    }

    @JsxFunction
    public void replace(String url) throws IOException {
        this.window_.getWebWindow().getHistory().removeCurrent();
        this.setHref(url);
    }

    @JsxFunction
    public String toString() {
        if (this.window_ != null) {
            return this.getHref();
        }
        return "";
    }

    @JsxGetter
    public String getHref() {
        Page page = this.window_.getWebWindow().getEnclosedPage();
        if (page == null) {
            return UNKNOWN;
        }
        try {
            String s;
            URL url = page.getUrl();
            boolean encodeHash = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_LOCATION_HASH_IS_DECODED);
            String hash = this.getHash(encodeHash);
            if (hash != null) {
                url = UrlUtils.getUrlWithNewRef(url, hash);
            }
            if ((s = url.toExternalForm()).startsWith("file:/") && !s.startsWith("file:///")) {
                s = "file:///" + s.substring("file:/".length());
            }
            return s;
        }
        catch (MalformedURLException e) {
            LOG.error(e.getMessage(), e);
            return page.getUrl().toExternalForm();
        }
    }

    @JsxSetter
    public void setHref(String newLocation) throws IOException {
        HtmlPage page = (HtmlPage)Location.getWindow(this.getStartingScope()).getWebWindow().getEnclosedPage();
        if (newLocation.startsWith("javascript:")) {
            String script = newLocation.substring(11);
            page.executeJavaScriptIfPossible(script, "new location value", 1);
            return;
        }
        try {
            URL url = page.getFullyQualifiedUrl(newLocation);
            if (StringUtils.isEmpty(newLocation)) {
                boolean dropFilename = page.getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.ANCHOR_EMPTY_HREF_NO_FILENAME);
                if (dropFilename) {
                    String path = url.getPath();
                    path = path.substring(0, path.lastIndexOf(47) + 1);
                    url = UrlUtils.getUrlWithNewPath(url, path);
                    url = UrlUtils.getUrlWithNewRef(url, null);
                } else {
                    url = UrlUtils.getUrlWithNewRef(url, null);
                }
            }
            WebWindow webWindow = this.getWindow().getWebWindow();
            webWindow.getWebClient().download(webWindow, "", new WebRequest(url), newLocation.endsWith("#"), "JS set location");
        }
        catch (MalformedURLException e) {
            LOG.error("setLocation('" + newLocation + "') Got MalformedURLException", e);
            throw e;
        }
    }

    @JsxGetter
    public String getSearch() {
        String search = this.getUrl().getQuery();
        if (search == null) {
            return "";
        }
        return "?" + search;
    }

    @JsxSetter
    public void setSearch(String search) throws Exception {
        this.setUrl(UrlUtils.getUrlWithNewQuery(this.getUrl(), search));
    }

    @JsxGetter
    public String getHash() {
        boolean decodeHash = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_LOCATION_HASH_IS_DECODED);
        String hash = this.hash_;
        if (decodeHash && this.hash_ != null) {
            hash = this.decodeHash(hash);
        }
        if (!StringUtils.isEmpty(hash)) {
            return "#" + hash;
        }
        return "";
    }

    private String getHash(boolean encoded) {
        if (this.hash_ == null || this.hash_.isEmpty()) {
            return null;
        }
        if (encoded) {
            return UrlUtils.encodeAnchor(this.hash_);
        }
        return this.hash_;
    }

    @JsxSetter
    public void setHash(String hash) {
        if (hash != null && hash.length() > 0 && '#' == hash.charAt(0)) {
            hash = hash.substring(1);
        }
        boolean hasChanged = hash != null && !hash.equals(this.hash_);
        String oldUrl = this.getHref();
        this.hash_ = hash;
        String newUrl = this.getHref();
        if (hasChanged) {
            HashChangeEvent event = new HashChangeEvent(this.getWindow(), "hashchange", oldUrl, newUrl);
            this.getWindow().executeEvent(event);
        }
    }

    private String decodeHash(String hash) {
        if (hash.indexOf(37) == -1) {
            return hash;
        }
        StringBuffer sb = new StringBuffer();
        Matcher m = DECODE_HASH_PATTERN.matcher(hash);
        while (m.find()) {
            String code = m.group(1);
            char u = (char)Character.digit(code.charAt(0), 16);
            char l = (char)Character.digit(code.charAt(1), 16);
            char replacement = (char)((u << 4) + l);
            m.appendReplacement(sb, "");
            sb.append(replacement);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    @JsxGetter
    public String getHostname() {
        return this.getUrl().getHost();
    }

    @JsxSetter
    public void setHostname(String hostname) throws Exception {
        this.setUrl(UrlUtils.getUrlWithNewHost(this.getUrl(), hostname));
    }

    @JsxGetter
    public String getHost() {
        URL url = this.getUrl();
        int port = url.getPort();
        String host = url.getHost();
        if (port == -1) {
            return host;
        }
        return host + ":" + port;
    }

    @JsxSetter
    public void setHost(String host) throws Exception {
        int port;
        String hostname;
        int index = host.indexOf(58);
        if (index != -1) {
            hostname = host.substring(0, index);
            port = Integer.parseInt(host.substring(index + 1));
        } else {
            hostname = host;
            port = -1;
        }
        URL url = UrlUtils.getUrlWithNewHostAndPort(this.getUrl(), hostname, port);
        this.setUrl(url);
    }

    @JsxGetter
    public String getPathname() {
        if (WebClient.URL_ABOUT_BLANK == this.getUrl()) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.URL_ABOUT_BLANK_HAS_EMPTY_PATH)) {
                return "";
            }
            return "/blank";
        }
        return this.getUrl().getPath();
    }

    @JsxSetter
    public void setPathname(String pathname) throws Exception {
        this.setUrl(UrlUtils.getUrlWithNewPath(this.getUrl(), pathname));
    }

    @JsxGetter
    public String getPort() {
        int port = this.getUrl().getPort();
        if (port == -1) {
            return "";
        }
        return Integer.toString(port);
    }

    @JsxSetter
    public void setPort(String port) throws Exception {
        this.setUrl(UrlUtils.getUrlWithNewPort(this.getUrl(), Integer.parseInt(port)));
    }

    @JsxGetter
    public String getProtocol() {
        return this.getUrl().getProtocol() + ":";
    }

    @JsxSetter
    public void setProtocol(String protocol) throws Exception {
        this.setUrl(UrlUtils.getUrlWithNewProtocol(this.getUrl(), protocol));
    }

    private URL getUrl() {
        return this.window_.getWebWindow().getEnclosedPage().getUrl();
    }

    private void setUrl(URL url) throws IOException {
        this.window_.getWebWindow().getWebClient().getPage(this.window_.getWebWindow(), new WebRequest(url));
    }
}

