/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlParameter;
import com.gargoylesoftware.htmlunit.html.applets.AppletClassLoader;
import com.gargoylesoftware.htmlunit.html.applets.AppletStubImpl;
import com.gargoylesoftware.htmlunit.util.UrlUtils;
import java.applet.Applet;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.NodeList;

public class HtmlApplet
extends HtmlElement {
    private static final Log LOG = LogFactory.getLog(HtmlApplet.class);
    private static final String ARCHIVE = "archive";
    private static final String CODEBASE = "codebase";
    public static final String TAG_NAME = "applet";
    private Applet applet_;
    private AppletClassLoader appletClassLoader_;
    private List<URL> archiveUrls_;

    HtmlApplet(String namespaceURI, String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(namespaceURI, qualifiedName, page, attributes);
    }

    public final String getCodebaseAttribute() {
        return this.getAttribute(CODEBASE);
    }

    public final String getArchiveAttribute() {
        return this.getAttribute(ARCHIVE);
    }

    public final String getCodeAttribute() {
        return this.getAttribute("code");
    }

    public final String getObjectAttribute() {
        return this.getAttribute("object");
    }

    public final String getAltAttribute() {
        return this.getAttribute("alt");
    }

    public final String getNameAttribute() {
        return this.getAttribute("name");
    }

    public final String getWidthAttribute() {
        return this.getAttribute("width");
    }

    public final String getHeightAttribute() {
        return this.getAttribute("height");
    }

    public final String getAlignAttribute() {
        return this.getAttribute("align");
    }

    public final String getHspaceAttribute() {
        return this.getAttribute("hspace");
    }

    public final String getVspaceAttribute() {
        return this.getAttribute("vspace");
    }

    public Applet getApplet() throws IOException {
        this.setupAppletIfNeeded();
        return this.applet_;
    }

    private synchronized void setupAppletIfNeeded() throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", this.getNameAttribute());
        params.put("object", this.getObjectAttribute());
        params.put("align", this.getAlignAttribute());
        params.put("alt", this.getAltAttribute());
        params.put("height", this.getHeightAttribute());
        params.put("hspace", this.getHspaceAttribute());
        params.put("vspace", this.getVspaceAttribute());
        params.put("width", this.getWidthAttribute());
        NodeList paramTags = this.getElementsByTagName("param");
        Iterator i$ = paramTags.iterator();
        while (i$.hasNext()) {
            HtmlElement paramTag = (HtmlElement)i$.next();
            HtmlParameter parameter = (HtmlParameter)paramTag;
            params.put(parameter.getNameAttribute(), parameter.getValueAttribute());
        }
        if (StringUtils.isEmpty((CharSequence)params.get(CODEBASE)) && StringUtils.isNotEmpty(this.getCodebaseAttribute())) {
            params.put(CODEBASE, this.getCodebaseAttribute());
        }
        String codebaseProperty = (String)params.get(CODEBASE);
        if (StringUtils.isEmpty((CharSequence)params.get(ARCHIVE)) && StringUtils.isNotEmpty(this.getArchiveAttribute())) {
            params.put(ARCHIVE, this.getArchiveAttribute());
        }
        if (null == this.applet_) {
            HtmlPage page = (HtmlPage)this.getPage();
            WebClient webclient = page.getWebClient();
            String appletClassName = this.getCodeAttribute();
            if (appletClassName.endsWith(".class")) {
                appletClassName = appletClassName.substring(0, appletClassName.length() - 6);
            }
            this.appletClassLoader_ = new AppletClassLoader();
            String documentUrl = page.getUrl().toExternalForm();
            String baseUrl = UrlUtils.resolveUrl(documentUrl, ".");
            if (StringUtils.isNotEmpty(codebaseProperty)) {
                baseUrl = UrlUtils.resolveUrl(baseUrl, codebaseProperty);
            }
            if (!baseUrl.endsWith("/")) {
                baseUrl = baseUrl + "/";
            }
            this.archiveUrls_ = new LinkedList<URL>();
            String[] archives = StringUtils.split((String)params.get(ARCHIVE), ',');
            if (null != archives) {
                for (int i = 0; i < archives.length; ++i) {
                    String tmpArchive = archives[i].trim();
                    String tempUrl = UrlUtils.resolveUrl(baseUrl, tmpArchive);
                    URL archiveUrl = UrlUtils.toUrlUnsafe(tempUrl);
                    this.appletClassLoader_.addArchiveToClassPath(archiveUrl);
                    this.archiveUrls_.add(archiveUrl);
                }
            }
            if (null == archives || archives.length == 0) {
                String tempUrl = UrlUtils.resolveUrl(baseUrl, this.getCodeAttribute());
                URL classUrl = UrlUtils.toUrlUnsafe(tempUrl);
                WebResponse response = webclient.loadWebResponse(new WebRequest(classUrl));
                try {
                    webclient.throwFailingHttpStatusCodeExceptionIfNecessary(response);
                    this.appletClassLoader_.addClassToClassPath(appletClassName, response);
                }
                catch (FailingHttpStatusCodeException e) {
                    LOG.error(e.getMessage(), e);
                }
            }
            try {
                Class<?> appletClass = this.appletClassLoader_.loadClass(appletClassName);
                this.applet_ = (Applet)appletClass.newInstance();
                this.applet_.setStub(new AppletStubImpl(this, params, UrlUtils.toUrlUnsafe(baseUrl), UrlUtils.toUrlUnsafe(documentUrl)));
                this.applet_.init();
                this.applet_.start();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public List<URL> getArchiveUrls() {
        return this.archiveUrls_;
    }
}

