/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.service;

import java.io.File;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.manager.SeleniumManager;
import org.openqa.selenium.manager.SeleniumManagerOutput;
import org.openqa.selenium.remote.NoSuchDriverException;
import org.openqa.selenium.remote.service.DriverService;

public class DriverFinder {
    public static SeleniumManagerOutput.Result getPath(DriverService service, Capabilities options) {
        return DriverFinder.getPath(service, options, false);
    }

    public static SeleniumManagerOutput.Result getPath(DriverService service, Capabilities options, boolean offline) {
        String message;
        Require.nonNull((String)"Browser options", (Object)options);
        SeleniumManagerOutput.Result result = new SeleniumManagerOutput.Result(System.getProperty(service.getDriverProperty()));
        if (result.getDriverPath() == null) {
            try {
                result = SeleniumManager.getInstance().getDriverPath(options, offline);
            }
            catch (Exception e) {
                throw new NoSuchDriverException(String.format("Unable to obtain: %s, error %s", options, e.getMessage()), e);
            }
        }
        if (result.getDriverPath() == null) {
            message = String.format("Unable to locate or obtain %s", service.getDriverName());
        } else if (!new File(result.getDriverPath()).exists()) {
            message = String.format("%s located at %s, but invalid", service.getDriverName(), result.getDriverPath());
        } else if (!new File(result.getDriverPath()).canExecute()) {
            message = String.format("%s located at %s, cannot be executed", service.getDriverName(), result.getDriverPath());
        } else {
            return result;
        }
        throw new NoSuchDriverException(message);
    }
}

