/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.MediaType;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import org.openqa.selenium.Beta;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonOutput;
import org.openqa.selenium.remote.AcceptedW3CCapabilityKeys;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandCodec;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.HttpSessionId;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.ResponseCodec;
import org.openqa.selenium.remote.codec.w3c.W3CHttpCommandCodec;
import org.openqa.selenium.remote.codec.w3c.W3CHttpResponseCodec;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.service.DriverService;

@Beta
public class RemoteWebDriverBuilder {
    private static final Set<String> ILLEGAL_METADATA_KEYS = ImmutableSet.of((Object)"alwaysMatch", (Object)"capabilities", (Object)"firstMatch");
    private static final AcceptedW3CCapabilityKeys OK_KEYS = new AcceptedW3CCapabilityKeys();
    private final List<Map<String, Object>> options = new ArrayList<Map<String, Object>>();
    private final Map<String, Object> metadata = new TreeMap<String, Object>();
    private final Map<String, Object> additionalCapabilities = new TreeMap<String, Object>();
    private URL remoteHost;
    private DriverService service;

    RemoteWebDriverBuilder() {
    }

    public RemoteWebDriverBuilder oneOf(Capabilities maybeThis, Capabilities ... orOneOfThese) {
        this.options.clear();
        this.addAlternative(maybeThis);
        for (Capabilities anOrOneOfThese : orOneOfThese) {
            this.addAlternative(anOrOneOfThese);
        }
        return this;
    }

    public RemoteWebDriverBuilder addAlternative(Capabilities options) {
        Map<String, Object> serialized = this.validate((Capabilities)Require.nonNull((String)"Driver options", (Object)options));
        this.options.add(serialized);
        return this;
    }

    public RemoteWebDriverBuilder addMetadata(String key, Object value) {
        if (ILLEGAL_METADATA_KEYS.contains(key)) {
            throw new IllegalArgumentException(key + " is a reserved key");
        }
        this.metadata.put((String)Require.nonNull((String)"Key", (Object)key), Require.nonNull((String)"Value", (Object)value));
        return this;
    }

    public RemoteWebDriverBuilder setCapability(String capabilityName, String value) {
        if (!OK_KEYS.test(capabilityName)) {
            throw new IllegalArgumentException("Capability is not valid");
        }
        if (value == null) {
            throw new IllegalArgumentException("Null values are not allowed");
        }
        this.additionalCapabilities.put(capabilityName, value);
        return this;
    }

    public RemoteWebDriverBuilder url(String url) {
        try {
            return this.url(new URL(url));
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException(e);
        }
    }

    public RemoteWebDriverBuilder url(URL url) {
        this.remoteHost = (URL)Require.nonNull((String)"Remote server URL", (Object)url);
        this.validateDriverServiceAndUrlConstraint();
        return this;
    }

    public RemoteWebDriverBuilder withDriverService(DriverService service) {
        this.service = (DriverService)Require.nonNull((String)"Driver service", (Object)service);
        this.validateDriverServiceAndUrlConstraint();
        return this;
    }

    public WebDriver build() {
        SpecCompliantExecutor executor;
        if (this.options.isEmpty() && this.additionalCapabilities.isEmpty()) {
            throw new SessionNotCreatedException("Refusing to create session without any capabilities");
        }
        Plan plan = this.getPlan();
        if (plan.isUsingDriverService()) {
            AtomicReference serviceRef = new AtomicReference();
            executor = new SpecCompliantExecutor(() -> {
                if (serviceRef.get() != null && ((DriverService)serviceRef.get()).isRunning()) {
                    throw new SessionNotCreatedException("Attempt to start the underlying service more than once");
                }
                try {
                    DriverService service = plan.getDriverService();
                    serviceRef.set(service);
                    service.start();
                    return service.getUrl();
                }
                catch (IOException e) {
                    throw new SessionNotCreatedException(e.getMessage(), (Throwable)e);
                }
            }, plan::writePayload, () -> ((DriverService)serviceRef.get()).stop());
        } else {
            executor = new SpecCompliantExecutor(() -> this.remoteHost, plan::writePayload, () -> {});
        }
        return new RemoteWebDriver(executor, (Capabilities)new ImmutableCapabilities());
    }

    private Map<String, Object> validate(Capabilities options) {
        return (Map)options.asMap().entrySet().stream().peek(entry -> {
            if (!OK_KEYS.test((String)entry.getKey())) {
                throw new IllegalArgumentException("Capability key is not a valid w3c key: " + (String)entry.getKey());
            }
        }).filter(entry -> entry.getValue() != null).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @VisibleForTesting
    Plan getPlan() {
        return new Plan();
    }

    private void validateDriverServiceAndUrlConstraint() {
        if (this.remoteHost != null && this.service != null) {
            throw new IllegalArgumentException("You may only set one of the remote url or the driver service to use.");
        }
    }

    private static class SpecCompliantExecutor
    implements CommandExecutor {
        private final CommandCodec<HttpRequest> commandCodec = new W3CHttpCommandCodec();
        private final ResponseCodec<HttpResponse> responseCodec = new W3CHttpResponseCodec();
        private final Supplier<URL> onStart;
        private final Consumer<JsonOutput> writePayload;
        private final Runnable onQuit;
        private HttpClient client;

        public SpecCompliantExecutor(Supplier<URL> onStart, Consumer<JsonOutput> writePayload, Runnable onQuit) {
            this.onStart = onStart;
            this.writePayload = writePayload;
            this.onQuit = onQuit;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Response execute(Command command) {
            HttpRequest request;
            if ("newSession".equals(command.getName())) {
                URL url = this.onStart.get();
                this.client = HttpClient.Factory.createDefault().createClient(url);
                request = new HttpRequest(HttpMethod.POST, "/session");
                request.setHeader("Cache-Control", "none");
                request.setHeader("Content-Type", MediaType.JSON_UTF_8.toString());
                StringBuilder payload = new StringBuilder();
                try (JsonOutput jsonOutput = new Json().newOutput((Appendable)payload);){
                    this.writePayload.accept(jsonOutput);
                }
                request.setContent(Contents.utf8String((CharSequence)payload.toString()));
            } else {
                request = this.commandCodec.encode(command);
            }
            try {
                Map value;
                HttpResponse response = this.client.execute(request);
                Response decodedResponse = this.responseCodec.decode(response);
                if (decodedResponse.getSessionId() == null && decodedResponse.getValue() instanceof Map && (value = (Map)decodedResponse.getValue()).get("sessionId") instanceof String) {
                    decodedResponse.setSessionId((String)value.get("sessionId"));
                }
                if (decodedResponse.getSessionId() == null && response.getTargetHost() != null) {
                    decodedResponse.setSessionId(HttpSessionId.getSessionId(response.getTargetHost()).orElse(null));
                }
                Response response2 = decodedResponse;
                return response2;
            }
            finally {
                if ("quit".equals(command.getName())) {
                    this.onQuit.run();
                }
            }
        }
    }

    @VisibleForTesting
    class Plan {
        private Plan() {
        }

        boolean isUsingDriverService() {
            return RemoteWebDriverBuilder.this.remoteHost == null;
        }

        @VisibleForTesting
        URL getRemoteHost() {
            return RemoteWebDriverBuilder.this.remoteHost;
        }

        DriverService getDriverService() {
            if (RemoteWebDriverBuilder.this.service != null) {
                return RemoteWebDriverBuilder.this.service;
            }
            ServiceLoader<DriverService.Builder> allLoaders = ServiceLoader.load(DriverService.Builder.class);
            return RemoteWebDriverBuilder.this.options.stream().map(HashMap::new).peek(map -> map.putAll(RemoteWebDriverBuilder.this.additionalCapabilities)).map(ImmutableCapabilities::new).map(caps -> StreamSupport.stream(allLoaders.spliterator(), true).filter(builder -> builder.score((Capabilities)caps) > 0).findFirst().orElse(null)).filter(Objects::nonNull).map(bs -> {
                try {
                    return bs.build();
                }
                catch (Throwable e) {
                    return null;
                }
            }).filter(Objects::nonNull).findFirst().orElseThrow(() -> new IllegalStateException("Unable to find a driver service"));
        }

        @VisibleForTesting
        void writePayload(JsonOutput out) {
            out.beginObject();
            out.name("capabilities");
            out.beginObject();
            HashMap<String, Object> always = new HashMap<String, Object>(RemoteWebDriverBuilder.this.options.isEmpty() ? new HashMap() : (Map)RemoteWebDriverBuilder.this.options.get(0));
            for (Map option2 : RemoteWebDriverBuilder.this.options) {
                for (Map.Entry entry : option2.entrySet()) {
                    if (!always.containsKey(entry.getKey()) || always.get(entry.getKey()).equals(entry.getValue())) continue;
                    always.remove(entry.getKey());
                }
            }
            always.putAll(RemoteWebDriverBuilder.this.additionalCapabilities);
            if (!always.isEmpty()) {
                out.name("alwaysMatch");
                out.beginObject();
                always.forEach((key, value) -> {
                    out.name(key);
                    out.write(value);
                });
                out.endObject();
            }
            if (!RemoteWebDriverBuilder.this.options.isEmpty()) {
                out.name("firstMatch");
                out.beginArray();
                RemoteWebDriverBuilder.this.options.forEach(option -> {
                    out.beginObject();
                    option.entrySet().stream().filter(entry -> !always.containsKey(entry.getKey())).filter(entry -> !RemoteWebDriverBuilder.this.additionalCapabilities.containsKey(entry.getKey())).forEach(entry -> {
                        out.name((String)entry.getKey());
                        out.write(entry.getValue());
                    });
                    out.endObject();
                });
                out.endArray();
            }
            out.endObject();
            RemoteWebDriverBuilder.this.metadata.forEach((key, value) -> {
                out.name(key);
                out.write(value);
            });
            out.endObject();
        }
    }
}

