/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.tracing.opentelemetry;

import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Primitives;
import io.grpc.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.trace.SpanContext;
import io.opentelemetry.trace.Tracer;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Status;
import org.openqa.selenium.remote.tracing.opentelemetry.OpenTelemetryContext;

class OpenTelemetrySpan
extends OpenTelemetryContext
implements AutoCloseable,
Span {
    private final io.opentelemetry.trace.Span span;
    private final Scope scope;
    private static final Map<Status.Kind, io.opentelemetry.trace.Status> statuses = new ImmutableMap.Builder().put((Object)Status.Kind.ABORTED, (Object)io.opentelemetry.trace.Status.ABORTED).put((Object)Status.Kind.CANCELLED, (Object)io.opentelemetry.trace.Status.CANCELLED).put((Object)Status.Kind.NOT_FOUND, (Object)io.opentelemetry.trace.Status.NOT_FOUND).put((Object)Status.Kind.OK, (Object)io.opentelemetry.trace.Status.OK).put((Object)Status.Kind.RESOURCE_EXHAUSTED, (Object)io.opentelemetry.trace.Status.RESOURCE_EXHAUSTED).put((Object)Status.Kind.UNKNOWN, (Object)io.opentelemetry.trace.Status.UNKNOWN).build();

    public OpenTelemetrySpan(Tracer tracer, Context context, io.opentelemetry.trace.Span span, Scope scope) {
        super(tracer, context);
        this.span = (io.opentelemetry.trace.Span)Require.nonNull((String)"Span", (Object)span);
        this.scope = (Scope)Require.nonNull((String)"Scope", (Object)scope);
    }

    @Override
    public Span setName(String name) {
        this.span.updateName((String)Require.nonNull((String)"Name to update to", (Object)name));
        return this;
    }

    @Override
    public Span setAttribute(String key, boolean value) {
        this.span.setAttribute((String)Require.nonNull((String)"Key", (Object)key), value);
        return this;
    }

    @Override
    public Span setAttribute(String key, Number value) {
        Require.nonNull((String)"Key", (Object)key);
        Require.nonNull((String)"Value", (Object)value);
        Class unwrapped = Primitives.unwrap(value.getClass());
        if (Double.TYPE.equals(unwrapped) || Float.TYPE.equals(unwrapped)) {
            this.span.setAttribute(key, value.doubleValue());
        } else {
            this.span.setAttribute(key, value.longValue());
        }
        return this;
    }

    @Override
    public Span setAttribute(String key, String value) {
        Require.nonNull((String)"Key", (Object)key);
        Require.nonNull((String)"Value", (Object)value);
        this.span.setAttribute(key, value);
        return this;
    }

    @Override
    public Span setStatus(Status status) {
        Require.nonNull((String)"Status", (Object)status);
        io.opentelemetry.trace.Status otStatus = statuses.get((Object)status.getKind());
        if (otStatus == null) {
            throw new IllegalArgumentException("Unrecognized status kind: " + (Object)((Object)status.getKind()));
        }
        otStatus.withDescription(status.getDescription());
        this.span.setStatus(otStatus);
        return this;
    }

    @Override
    public void close() {
        this.scope.close();
        this.span.end();
    }

    @Override
    public String toString() {
        SpanContext context = this.span.getContext();
        return "OpenTelemetrySpan{traceId=" + context.getTraceId() + ",spanId=" + context.getSpanId() + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof OpenTelemetrySpan)) {
            return false;
        }
        OpenTelemetrySpan that = (OpenTelemetrySpan)o;
        SpanContext thisContext = this.span.getContext();
        SpanContext thatContext = that.span.getContext();
        return Objects.equals(thisContext.getSpanId(), thatContext.getSpanId()) && Objects.equals(thisContext.getTraceId(), thatContext.getTraceId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.span);
    }
}

