/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.network.model;

import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.devtools.network.model.RequestId;
import org.openqa.selenium.devtools.network.model.Response;
import org.openqa.selenium.devtools.network.model.SecurityDetails;
import org.openqa.selenium.devtools.network.model.SignedExchangeError;
import org.openqa.selenium.devtools.network.model.SignedExchangeHeader;
import org.openqa.selenium.devtools.network.model.SignedExchangeInfo;
import org.openqa.selenium.json.JsonInput;

public class SignedExchangeReceived {
    private final RequestId requestId;
    private final SignedExchangeInfo info;

    private SignedExchangeReceived(RequestId requestId, SignedExchangeInfo info) {
        this.requestId = Objects.requireNonNull(requestId, "'requestId' is required for SignedExchangeReceived");
        this.info = info;
    }

    private static SignedExchangeReceived fromJson(JsonInput input) {
        RequestId requestId = new RequestId(input.nextString());
        SignedExchangeInfo info = null;
        block18: while (input.hasNext()) {
            switch (input.nextName()) {
                case "info": {
                    input.beginObject();
                    Response outerResponse = null;
                    SignedExchangeHeader header = null;
                    SecurityDetails securityDetails = null;
                    List errors = null;
                    block19: while (input.hasNext()) {
                        switch (input.nextName()) {
                            case "outerResponse": {
                                outerResponse = (Response)input.read((Type)((Object)Response.class));
                                continue block19;
                            }
                            case "header": {
                                header = (SignedExchangeHeader)input.read((Type)((Object)SignedExchangeHeader.class));
                                continue block19;
                            }
                            case "securityDetails": {
                                securityDetails = (SecurityDetails)input.read((Type)((Object)SecurityDetails.class));
                                continue block19;
                            }
                            case "errors": {
                                while (input.hasNext()) {
                                    errors = (List)input.read(new TypeToken<List<SignedExchangeError>>(){}.getType());
                                }
                                continue block19;
                            }
                        }
                        input.skipValue();
                    }
                    info = new SignedExchangeInfo(outerResponse, header, securityDetails, errors);
                    continue block18;
                }
            }
            input.skipValue();
        }
        return new SignedExchangeReceived(requestId, info);
    }
}

