/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.network.model;

import org.openqa.selenium.devtools.network.model.MonotonicTime;
import org.openqa.selenium.devtools.network.model.RequestId;
import org.openqa.selenium.devtools.network.model.ResourcePriority;
import org.openqa.selenium.json.JsonInput;

public class ResourceChangedPriority {
    private final RequestId requestId;
    private final ResourcePriority newPriority;
    private final MonotonicTime timestamp;

    private ResourceChangedPriority(RequestId requestId, ResourcePriority newPriority, MonotonicTime timestamp) {
        this.requestId = requestId;
        this.newPriority = newPriority;
        this.timestamp = timestamp;
    }

    private static ResourceChangedPriority fromJson(JsonInput input) {
        RequestId requestId = new RequestId(input.nextString());
        ResourcePriority newPriority = null;
        MonotonicTime timestamp = null;
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "newPriority": {
                    newPriority = ResourcePriority.valueOf(input.nextString());
                    continue block8;
                }
                case "timestamp": {
                    timestamp = MonotonicTime.parse(input.nextNumber());
                    continue block8;
                }
            }
            input.skipValue();
        }
        return new ResourceChangedPriority(requestId, newPriority, timestamp);
    }

    public RequestId getRequestId() {
        return this.requestId;
    }

    public ResourcePriority getNewPriority() {
        return this.newPriority;
    }

    public MonotonicTime getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return "ResourceChangedPriority{requestId=" + this.requestId + ", newPriority=" + (Object)((Object)this.newPriority) + ", timestamp=" + this.timestamp.getTimeStamp().toString() + '}';
    }
}

