/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.os;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.io.CircularOutputStream;
import org.openqa.selenium.io.MultiOutputStream;

public class ExternalProcess {
    private static final Logger LOG = Logger.getLogger(ExternalProcess.class.getName());
    private final Process process;
    private final CircularOutputStream outputStream;

    public static Builder builder() {
        return new Builder();
    }

    public ExternalProcess(Process process, CircularOutputStream outputStream) {
        this.process = process;
        this.outputStream = outputStream;
    }

    public String getOutput() {
        return this.outputStream.toString();
    }

    public boolean isAlive() {
        return this.process.isAlive();
    }

    public boolean waitFor(Duration duration) throws InterruptedException {
        return this.process.waitFor(duration.toMillis(), TimeUnit.MILLISECONDS);
    }

    public int exitValue() {
        return this.process.exitValue();
    }

    public void shutdown() {
        this.shutdown(Duration.ofSeconds(4L));
    }

    public void shutdown(Duration timeout) {
        if (this.process.supportsNormalTermination()) {
            this.process.destroy();
            try {
                if (this.process.waitFor(timeout.toMillis(), TimeUnit.MILLISECONDS)) {
                    return;
                }
            }
            catch (InterruptedException ex) {
                Thread.interrupted();
            }
        }
        this.process.destroyForcibly();
    }

    public static class Builder {
        private ProcessBuilder builder = new ProcessBuilder(new String[0]);
        private OutputStream copyOutputTo;
        private int bufferSize = 32768;

        Builder() {
        }

        public Builder command(String executable, List<String> arguments) {
            ArrayList<String> command = new ArrayList<String>(arguments.size() + 1);
            command.add(executable);
            command.addAll(arguments);
            this.builder.command(command);
            return this;
        }

        public Builder command(List<String> command) {
            this.builder.command(command);
            return this;
        }

        public Builder command(String ... command) {
            this.builder.command(command);
            return this;
        }

        public List<String> command() {
            return Collections.unmodifiableList(this.builder.command());
        }

        public Builder environment(String name, String value) {
            Require.argument((String)"name", (Object)name).nonNull();
            Require.argument((String)"value", (Object)value).nonNull();
            this.builder.environment().put(name, value);
            return this;
        }

        public Map<String, String> environment() {
            return this.builder.environment();
        }

        public File directory() {
            return this.builder.directory();
        }

        public Builder directory(String directory) {
            return this.directory(new File(directory));
        }

        public Builder directory(File directory) {
            this.builder.directory(directory);
            return this;
        }

        public Builder copyOutputTo(OutputStream stream) {
            this.copyOutputTo = stream;
            return this;
        }

        public Builder bufferSize(int toKeep) {
            this.bufferSize = toKeep;
            return this;
        }

        public ExternalProcess start() throws UncheckedIOException {
            CircularOutputStream circular;
            Process process;
            this.builder.redirectErrorStream(true);
            try {
                process = this.builder.start();
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
            try {
                circular = new CircularOutputStream(this.bufferSize);
                new Thread(() -> {
                    InputStream input = process.getInputStream();
                    MultiOutputStream output = new MultiOutputStream(circular, this.copyOutputTo);
                    while (process.isAlive()) {
                        try {
                            input.transferTo(output);
                        }
                        catch (IOException ex) {
                            LOG.log(Level.WARNING, "failed to copy the output of process " + process.pid(), ex);
                        }
                    }
                }).start();
            }
            catch (Throwable t) {
                try {
                    process.destroyForcibly();
                }
                catch (Throwable t2) {
                    t.addSuppressed(t2);
                }
                throw t;
            }
            return new ExternalProcess(process, circular);
        }
    }
}

