/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.manager;

import com.google.common.io.CharStreams;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.Beta;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.manager.SeleniumManagerJsonOutput;

@Beta
public class SeleniumManager {
    private static final Logger LOG = Logger.getLogger(SeleniumManager.class.getName());
    private static final String SELENIUM_MANAGER = "selenium-manager";
    private static final String EXE = ".exe";
    private static final String INFO = "INFO";
    private static final String WARN = "WARN";
    private static final String DEBUG = "DEBUG";
    private static SeleniumManager manager;
    private File binary;

    private SeleniumManager() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (this.binary != null && this.binary.exists()) {
                try {
                    Files.delete(this.binary.toPath());
                }
                catch (IOException e) {
                    LOG.warning(String.format("%s deleting temporal file: %s", e.getClass().getSimpleName(), e.getMessage()));
                }
            }
        }));
    }

    public static SeleniumManager getInstance() {
        if (manager == null) {
            manager = new SeleniumManager();
        }
        return manager;
    }

    private static String runCommand(String ... command) {
        LOG.fine(String.format("Executing Process: %s", Arrays.toString(command)));
        String output = "";
        int code = 0;
        try {
            Process process = new ProcessBuilder(command).redirectErrorStream(true).start();
            process.waitFor();
            code = process.exitValue();
            output = CharStreams.toString((Readable)new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
        }
        catch (InterruptedException e) {
            LOG.warning(String.format("Interrupted exception running command %s: %s", Arrays.toString(command), e.getMessage()));
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            LOG.warning(String.format("%s running command %s: %s", e.getClass().getSimpleName(), Arrays.toString(command), e.getMessage()));
        }
        SeleniumManagerJsonOutput jsonOutput = (SeleniumManagerJsonOutput)new Json().toType(output, SeleniumManagerJsonOutput.class);
        if (code > 0) {
            throw new WebDriverException("Unsuccessful command executed: " + Arrays.toString(command) + "\n" + jsonOutput.result.message);
        }
        jsonOutput.logs.forEach(logged -> {
            if (logged.level.equalsIgnoreCase(WARN)) {
                LOG.warning(logged.message);
            }
            if (logged.level.equalsIgnoreCase(DEBUG) || logged.level.equalsIgnoreCase(INFO)) {
                LOG.fine(logged.message);
            }
        });
        return jsonOutput.result.message;
    }

    private synchronized File getBinary() {
        if (this.binary == null) {
            try {
                Platform current = Platform.getCurrent();
                String folder = "linux";
                String extension = "";
                if (current.is(Platform.WINDOWS)) {
                    extension = EXE;
                    folder = "windows";
                } else if (current.is(Platform.MAC)) {
                    folder = "macos";
                }
                String binaryPath = String.format("%s/%s%s", folder, SELENIUM_MANAGER, extension);
                try (InputStream inputStream = this.getClass().getResourceAsStream(binaryPath);){
                    Path tmpPath = Files.createTempDirectory(SELENIUM_MANAGER + System.nanoTime(), new FileAttribute[0]);
                    File tmpFolder = tmpPath.toFile();
                    tmpFolder.deleteOnExit();
                    this.binary = new File(tmpFolder, SELENIUM_MANAGER + extension);
                    Files.copy(inputStream, this.binary.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                this.binary.setExecutable(true);
            }
            catch (Exception e) {
                throw new WebDriverException("Unable to obtain Selenium Manager Binary", (Throwable)e);
            }
        }
        return this.binary;
    }

    private String getBrowserBinary(Capabilities options) {
        List<String> vendorOptionsCapabilities = Arrays.asList("moz:firefoxOptions", "goog:chromeOptions", "ms:edgeOptions");
        for (String vendorOptionsCapability : vendorOptionsCapabilities) {
            if (!options.asMap().containsKey(vendorOptionsCapability)) continue;
            try {
                Map vendorOptions = (Map)options.getCapability(vendorOptionsCapability);
                return (String)vendorOptions.get("binary");
            }
            catch (Exception e) {
                LOG.warning(String.format("Exception while retrieving the browser binary path. %s: %s", options, e.getMessage()));
            }
        }
        return null;
    }

    public String getDriverPath(Capabilities options) {
        Proxy proxy;
        String browserBinary;
        LOG.fine("Applicable driver not found; attempting to install with Selenium Manager (Beta)");
        File binaryFile = this.getBinary();
        if (binaryFile == null) {
            return null;
        }
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add(binaryFile.getAbsolutePath());
        commandList.add("--browser");
        commandList.add(options.getBrowserName());
        commandList.add("--output");
        commandList.add("json");
        if (!options.getBrowserVersion().isEmpty()) {
            commandList.add("--browser-version");
            commandList.add(options.getBrowserVersion());
        }
        if ((browserBinary = this.getBrowserBinary(options)) != null && !browserBinary.isEmpty()) {
            commandList.add("--browser-path");
            commandList.add(browserBinary);
        }
        if (this.getLogLevel().intValue() <= Level.FINE.intValue()) {
            commandList.add("--debug");
        }
        if ((proxy = (Proxy)options.getCapability("proxy")) != null) {
            if (proxy.getSslProxy() != null) {
                commandList.add("--proxy");
                commandList.add(proxy.getSslProxy());
            } else if (proxy.getHttpProxy() != null) {
                commandList.add("--proxy");
                commandList.add(proxy.getHttpProxy());
            }
        }
        String path = SeleniumManager.runCommand(commandList.toArray(new String[0]));
        LOG.fine(String.format("Using driver at location: %s", path));
        return path;
    }

    private Level getLogLevel() {
        Level level = LOG.getLevel();
        if (level == null && LOG.getParent() != null) {
            level = LOG.getParent().getLevel();
        }
        if (level == null) {
            return Level.INFO;
        }
        return level;
    }
}

