/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.Routable;
import org.openqa.selenium.remote.http.UrlTemplate;

public abstract class Route
implements HttpHandler,
Routable {
    private static final Json JSON = new Json();

    public HttpHandler fallbackTo(Supplier<HttpHandler> handler) {
        Objects.requireNonNull(handler, "Handler to use must be set.");
        return req -> {
            if (this.matches(req)) {
                return this.execute(req);
            }
            return Objects.requireNonNull((HttpHandler)handler.get(), "Handler to use must be set.").execute(req);
        };
    }

    @Override
    public final HttpResponse execute(HttpRequest req) {
        if (!this.matches(req)) {
            return (HttpResponse)new HttpResponse().setStatus(404).setContent((Supplier)Contents.utf8String(JSON.toJson((Object)ImmutableMap.of((Object)"value", (Object)ImmutableMap.of((Object)"error", (Object)"unknown command", (Object)"message", (Object)("Unable to find handler for " + req), (Object)"stacktrace", (Object)"")))));
        }
        HttpResponse res = this.handle(req);
        if (res != null) {
            return res;
        }
        return (HttpResponse)((HttpResponse)((HttpResponse)new HttpResponse().setStatus(500).addHeader("WebDriver-Error", "unsupported operation")).addHeader("Selenium-Route", "NULL_RES")).setContent((Supplier)Contents.utf8String(JSON.toJson((Object)ImmutableMap.of((Object)"value", (Object)ImmutableMap.of((Object)"error", (Object)"unsupported operation", (Object)"message", (Object)String.format("Found handler for %s, but nothing was returned", req), (Object)"stacktrace", (Object)"")))));
    }

    protected abstract HttpResponse handle(HttpRequest var1);

    public static PredicatedConfig matching(Predicate<HttpRequest> predicate) {
        Objects.requireNonNull(predicate, "Predicate to use must be set.");
        return new PredicatedConfig(predicate);
    }

    public static TemplatizedRouteConfig delete(String template) {
        Objects.requireNonNull(template, "URL template to use must be set.");
        UrlTemplate urlTemplate = new UrlTemplate(template);
        return new TemplatizedRouteConfig(new MatchesHttpMethod(HttpMethod.DELETE).and(new MatchesTemplate(urlTemplate)), urlTemplate);
    }

    public static TemplatizedRouteConfig get(String template) {
        Objects.requireNonNull(template, "URL template to use must be set.");
        UrlTemplate urlTemplate = new UrlTemplate(template);
        return new TemplatizedRouteConfig(new MatchesHttpMethod(HttpMethod.GET).and(new MatchesTemplate(urlTemplate)), urlTemplate);
    }

    public static TemplatizedRouteConfig post(String template) {
        Objects.requireNonNull(template, "URL template to use must be set.");
        UrlTemplate urlTemplate = new UrlTemplate(template);
        return new TemplatizedRouteConfig(new MatchesHttpMethod(HttpMethod.POST).and(new MatchesTemplate(urlTemplate)), urlTemplate);
    }

    public static NestedRouteConfig prefix(String prefix) {
        Objects.requireNonNull(prefix, "Prefix to use must be set.");
        Preconditions.checkArgument((!prefix.isEmpty() ? 1 : 0) != 0, (Object)"Prefix to use must not be of 0 length");
        return new NestedRouteConfig(prefix);
    }

    public static Route combine(Routable first, Routable ... others) {
        Objects.requireNonNull(first, "At least one route must be set.");
        return new CombinedRoute(Stream.concat(Stream.of(first), Stream.of(others)));
    }

    public static Route combine(Iterable<Routable> routes) {
        Objects.requireNonNull(routes, "At least one route must be set.");
        return new CombinedRoute(StreamSupport.stream(routes.spliterator(), false));
    }

    private static class PredicatedRoute
    extends Route {
        private final Predicate<HttpRequest> predicate;
        private final Supplier<HttpHandler> supplier;

        private PredicatedRoute(Predicate<HttpRequest> predicate, Supplier<HttpHandler> supplier) {
            this.predicate = Objects.requireNonNull(predicate);
            this.supplier = Objects.requireNonNull(supplier);
        }

        @Override
        public boolean matches(HttpRequest httpRequest) {
            return this.predicate.test(httpRequest);
        }

        @Override
        protected HttpResponse handle(HttpRequest req) {
            HttpHandler handler = this.supplier.get();
            if (handler == null) {
                throw new IllegalStateException("No handler available.");
            }
            return handler.execute(req);
        }
    }

    public static class PredicatedConfig {
        private final Predicate<HttpRequest> predicate;

        private PredicatedConfig(Predicate<HttpRequest> predicate) {
            this.predicate = Objects.requireNonNull(predicate);
        }

        public Route to(Supplier<HttpHandler> handler) {
            Objects.requireNonNull(handler, "Handler supplier must be set.");
            return new PredicatedRoute(this.predicate, handler);
        }
    }

    private static class CombinedRoute
    extends Route {
        private final List<Routable> allRoutes;

        private CombinedRoute(Stream<Routable> routes) {
            this.allRoutes = ((ImmutableList)routes.collect(ImmutableList.toImmutableList())).reverse();
            Preconditions.checkArgument((!this.allRoutes.isEmpty() ? 1 : 0) != 0, (Object)"At least one route must be specified.");
        }

        @Override
        public boolean matches(HttpRequest request) {
            return this.allRoutes.stream().anyMatch(route -> route.matches(request));
        }

        @Override
        protected HttpResponse handle(HttpRequest req) {
            return this.allRoutes.stream().filter(route -> route.matches(req)).findFirst().map(route -> route).orElse(request -> (HttpResponse)new HttpResponse().setStatus(404).setContent((Supplier)Contents.utf8String("No handler found for " + request))).execute(req);
        }
    }

    private static class NestedRoute
    extends Route {
        private final String[] prefixPaths;
        private final String prefix;
        private final Route route;

        private NestedRoute(String prefix, Route route) {
            this.prefixPaths = Objects.requireNonNull(prefix, "Prefix must be set.").split("/");
            this.prefix = prefix;
            this.route = Objects.requireNonNull(route, "Target for requests must be set.");
        }

        @Override
        public boolean matches(HttpRequest request) {
            return this.hasPrefix(request) && this.route.matches(this.transform(request));
        }

        private boolean hasPrefix(HttpRequest request) {
            String[] parts = request.getUri().split("/");
            if (parts.length < this.prefixPaths.length) {
                return false;
            }
            for (int i = 0; i < this.prefixPaths.length; ++i) {
                if (this.prefixPaths[i].equals(parts[i])) continue;
                return false;
            }
            return true;
        }

        @Override
        protected HttpResponse handle(HttpRequest req) {
            return this.route.execute(this.transform(req));
        }

        private HttpRequest transform(HttpRequest request) {
            String unprefixed = this.hasPrefix(request) ? request.getUri().substring(this.prefix.length()) : request.getUri();
            HttpRequest toForward = new HttpRequest(request.getMethod(), unprefixed);
            request.getHeaderNames().forEach(name -> {
                if (name == null) {
                    return;
                }
                request.getHeaders((String)name).forEach(value -> toForward.addHeader((String)name, (String)value));
            });
            request.getAttributeNames().forEach(attr -> toForward.setAttribute((String)attr, request.getAttribute((String)attr)));
            LinkedList rawPrefixes = request.getAttribute("selenium.route");
            if (!(rawPrefixes instanceof List)) {
                rawPrefixes = new LinkedList();
            }
            List prefixes = (List)Stream.concat(((List)rawPrefixes).stream(), Stream.of(this.prefix)).map(String::valueOf).collect(ImmutableList.toImmutableList());
            toForward.setAttribute("selenium.route", prefixes);
            request.getQueryParameterNames().forEach(name -> request.getQueryParameters((String)name).forEach(value -> toForward.addQueryParameter((String)name, (String)value)));
            toForward.setContent(request.getContent());
            return toForward;
        }
    }

    public static class NestedRouteConfig {
        private final String prefix;

        private NestedRouteConfig(String prefix) {
            this.prefix = Objects.requireNonNull(prefix, "Prefix must be set.");
        }

        public Route to(Route route) {
            Objects.requireNonNull(route, "Target for requests must be set.");
            return new NestedRoute(this.prefix, route);
        }
    }

    private static class MatchesTemplate
    implements Predicate<HttpRequest> {
        private final UrlTemplate template;

        private MatchesTemplate(UrlTemplate template) {
            this.template = Objects.requireNonNull(template, "URL template to test must be set.");
        }

        @Override
        public boolean test(HttpRequest request) {
            return this.template.match(request.getUri()) != null;
        }
    }

    private static class MatchesHttpMethod
    implements Predicate<HttpRequest> {
        private final HttpMethod method;

        private MatchesHttpMethod(HttpMethod method) {
            this.method = Objects.requireNonNull(method, "HTTP method to test must be set.");
        }

        @Override
        public boolean test(HttpRequest request) {
            return this.method == request.getMethod();
        }
    }

    private static class TemplatizedRoute
    extends Route {
        private final UrlTemplate template;
        private final Predicate<HttpRequest> predicate;
        private final Function<Map<String, String>, HttpHandler> handlerFunction;

        private TemplatizedRoute(UrlTemplate template, Predicate<HttpRequest> predicate, Function<Map<String, String>, HttpHandler> handlerFunction) {
            this.template = Objects.requireNonNull(template);
            this.predicate = Objects.requireNonNull(predicate);
            this.handlerFunction = Objects.requireNonNull(handlerFunction);
        }

        @Override
        public boolean matches(HttpRequest request) {
            return this.predicate.test(request);
        }

        @Override
        protected HttpResponse handle(HttpRequest req) {
            UrlTemplate.Match match = this.template.match(req.getUri());
            HttpHandler handler = this.handlerFunction.apply((Map<String, String>)(match == null ? ImmutableMap.of() : match.getParameters()));
            if (handler == null) {
                return (HttpResponse)new HttpResponse().setStatus(500).setContent((Supplier)Contents.utf8String("Unable to find handler for " + req));
            }
            return handler.execute(req);
        }
    }

    public static class TemplatizedRouteConfig {
        private final Predicate<HttpRequest> predicate;
        private final UrlTemplate template;

        private TemplatizedRouteConfig(Predicate<HttpRequest> predicate, UrlTemplate template) {
            this.predicate = Objects.requireNonNull(predicate);
            this.template = Objects.requireNonNull(template);
        }

        public Route to(Supplier<HttpHandler> handler) {
            Objects.requireNonNull(handler, "Handler supplier must be set.");
            return this.to((Map<String, String> params) -> (HttpHandler)handler.get());
        }

        public Route to(Function<Map<String, String>, HttpHandler> handlerFunc) {
            Objects.requireNonNull(handlerFunc, "Handler creator must be set.");
            return new TemplatizedRoute(this.template, this.predicate, handlerFunc);
        }
    }
}

