/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http.jdk;

import com.google.auto.service.AutoService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpResponse;
import java.net.http.HttpTimeoutException;
import java.net.http.WebSocket;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.Credentials;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.UsernameAndPassword;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.http.BinaryMessage;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.CloseMessage;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpClientName;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.Message;
import org.openqa.selenium.remote.http.TextMessage;
import org.openqa.selenium.remote.http.WebSocket;
import org.openqa.selenium.remote.http.jdk.JdkHttpMessages;

public class JdkHttpClient
implements HttpClient {
    public static final Logger LOG = Logger.getLogger(JdkHttpClient.class.getName());
    private final JdkHttpMessages messages;
    private java.net.http.HttpClient client;
    private WebSocket websocket;
    private final ExecutorService executorService;
    private final Duration readTimeout;

    JdkHttpClient(ClientConfig config) {
        Objects.requireNonNull(config, "Client config must be set");
        this.messages = new JdkHttpMessages(config);
        this.readTimeout = config.readTimeout();
        this.executorService = Executors.newCachedThreadPool();
        HttpClient.Builder builder = java.net.http.HttpClient.newBuilder().connectTimeout(config.connectionTimeout()).followRedirects(HttpClient.Redirect.ALWAYS).executor(this.executorService);
        Credentials credentials = config.credentials();
        String info = config.baseUri().getUserInfo();
        if (info != null && !info.trim().isEmpty()) {
            String[] parts = info.split(":", 2);
            final String username = parts[0];
            final String password = parts.length > 1 ? parts[1] : null;
            Authenticator authenticator = new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(username, password.toCharArray());
                }
            };
            builder = builder.authenticator(authenticator);
        } else if (credentials != null) {
            if (!(credentials instanceof UsernameAndPassword)) {
                throw new IllegalArgumentException("Credentials must be a user name and password: " + credentials);
            }
            final UsernameAndPassword uap = (UsernameAndPassword)credentials;
            Authenticator authenticator = new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(uap.username(), uap.password().toCharArray());
                }
            };
            builder = builder.authenticator(authenticator);
        }
        final Proxy proxy = config.proxy();
        if (proxy != null) {
            ProxySelector proxySelector = new ProxySelector(){

                @Override
                public List<Proxy> select(URI uri) {
                    if (proxy == null) {
                        return List.of();
                    }
                    if (uri.getScheme().toLowerCase().startsWith("http")) {
                        return List.of(proxy);
                    }
                    return List.of();
                }

                @Override
                public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
                }
            };
            builder = builder.proxy(proxySelector);
        }
        this.client = builder.build();
    }

    public WebSocket openSocket(HttpRequest request, final WebSocket.Listener listener) {
        URI uri = this.getWebSocketUri(request);
        CompletableFuture<java.net.http.WebSocket> webSocketCompletableFuture = this.client.newWebSocketBuilder().buildAsync(uri, new WebSocket.Listener(){
            final StringBuilder builder = new StringBuilder();
            final ByteArrayOutputStream buffer = new ByteArrayOutputStream();

            @Override
            public CompletionStage<?> onText(java.net.http.WebSocket webSocket, CharSequence data, boolean last) {
                LOG.fine("Text message received. Appending data");
                this.builder.append(data);
                if (last) {
                    LOG.fine("Final part of text message received. Calling listener with " + this.builder);
                    listener.onText((CharSequence)this.builder.toString());
                    this.builder.setLength(0);
                }
                webSocket.request(1L);
                return null;
            }

            @Override
            public CompletionStage<?> onBinary(java.net.http.WebSocket webSocket, ByteBuffer data, boolean last) {
                LOG.fine("Binary data received. Appending data");
                byte[] ary = new byte[8192];
                while (data.hasRemaining()) {
                    int n = Math.min(ary.length, data.remaining());
                    data.get(ary, 0, n);
                    this.buffer.write(ary, 0, n);
                }
                if (last) {
                    LOG.fine("Final part of binary data received. Calling listener with " + this.buffer.size() + " bytes of data");
                    listener.onBinary(this.buffer.toByteArray());
                    this.buffer.reset();
                }
                webSocket.request(1L);
                return null;
            }

            @Override
            public CompletionStage<?> onClose(java.net.http.WebSocket webSocket, int statusCode, String reason) {
                LOG.fine("Closing websocket");
                listener.onClose(statusCode, reason);
                return null;
            }

            @Override
            public void onError(java.net.http.WebSocket webSocket, Throwable error) {
                LOG.log(Level.FINE, error, () -> "An error has occurred: " + error.getMessage());
                listener.onError(error);
                webSocket.request(1L);
            }
        });
        final java.net.http.WebSocket underlyingSocket = webSocketCompletableFuture.join();
        this.websocket = new WebSocket(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public WebSocket send(Message message) {
                Supplier<CompletableFuture> makeCall;
                if (message instanceof BinaryMessage) {
                    BinaryMessage binaryMessage = (BinaryMessage)message;
                    LOG.fine("Sending binary message");
                    makeCall = () -> underlyingSocket.sendBinary(ByteBuffer.wrap(binaryMessage.data()), true);
                } else if (message instanceof TextMessage) {
                    TextMessage textMessage = (TextMessage)message;
                    LOG.fine("Sending text message: " + textMessage.text());
                    makeCall = () -> underlyingSocket.sendText(textMessage.text(), true);
                } else {
                    if (!(message instanceof CloseMessage)) throw new IllegalArgumentException("Unsupported message type: " + message);
                    LOG.fine("Sending close message");
                    CloseMessage closeMessage = (CloseMessage)message;
                    makeCall = () -> underlyingSocket.sendClose(closeMessage.code(), closeMessage.reason());
                }
                java.net.http.WebSocket webSocket = underlyingSocket;
                synchronized (webSocket) {
                    long start = System.currentTimeMillis();
                    CompletableFuture future = makeCall.get();
                    try {
                        future.get(JdkHttpClient.this.readTimeout.toMillis(), TimeUnit.MILLISECONDS);
                    }
                    catch (CancellationException e) {
                        try {
                            throw new WebDriverException(e.getMessage(), (Throwable)e);
                            catch (ExecutionException e2) {
                                Throwable cause = e2.getCause();
                                if (cause != null) throw new WebDriverException(cause);
                                throw new WebDriverException((Throwable)e2);
                            }
                            catch (InterruptedException e3) {
                                Thread.currentThread().interrupt();
                                throw new WebDriverException(e3.getMessage());
                            }
                            catch (java.util.concurrent.TimeoutException e4) {
                                throw new TimeoutException((Throwable)e4);
                            }
                        }
                        catch (Throwable throwable) {
                            LOG.fine(String.format("Websocket response to %s read in %sms", message, System.currentTimeMillis() - start));
                            throw throwable;
                        }
                    }
                    LOG.fine(String.format("Websocket response to %s read in %sms", message, System.currentTimeMillis() - start));
                    return this;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() {
                LOG.fine("Closing websocket");
                java.net.http.WebSocket webSocket = underlyingSocket;
                synchronized (webSocket) {
                    if (!underlyingSocket.isOutputClosed()) {
                        underlyingSocket.sendClose(1000, "WebDriver closing socket");
                    }
                }
            }
        };
        return this.websocket;
    }

    private URI getWebSocketUri(HttpRequest request) {
        URI uri = this.messages.getRawUri(request);
        if ("http".equalsIgnoreCase(uri.getScheme())) {
            try {
                uri = new URI("ws", uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        if ("https".equalsIgnoreCase(uri.getScheme())) {
            try {
                uri = new URI("wss", uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return uri;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HttpResponse execute(HttpRequest req) throws UncheckedIOException {
        HttpResponse httpResponse;
        Objects.requireNonNull(req, "Request");
        LOG.fine("Executing request: " + req);
        long start = System.currentTimeMillis();
        HttpResponse.BodyHandler<byte[]> byteHandler = HttpResponse.BodyHandlers.ofByteArray();
        try {
            httpResponse = this.messages.createResponse(this.client.send(this.messages.createRequest(req), byteHandler));
        }
        catch (HttpTimeoutException e) {
            try {
                throw new TimeoutException((Throwable)e);
                catch (IOException e2) {
                    throw new UncheckedIOException(e2);
                }
                catch (InterruptedException e3) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e3);
                }
            }
            catch (Throwable throwable) {
                LOG.fine(String.format("Ending request %s in %sms", req, System.currentTimeMillis() - start));
                throw throwable;
            }
        }
        LOG.fine(String.format("Ending request %s in %sms", req, System.currentTimeMillis() - start));
        return httpResponse;
    }

    public void close() {
        this.executorService.shutdownNow();
        if (this.websocket != null) {
            this.websocket.close();
        }
        this.client = null;
    }

    @HttpClientName(value="jdk-http-client")
    @AutoService(value={HttpClient.Factory.class})
    public static class Factory
    implements HttpClient.Factory {
        public HttpClient createClient(ClientConfig config) {
            Objects.requireNonNull(config, "Client config must be set");
            return new JdkHttpClient(config);
        }
    }
}

