/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.stream.StreamSupport;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxDriverService;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.HasExtensions;
import org.openqa.selenium.html5.LocalStorage;
import org.openqa.selenium.html5.SessionStorage;
import org.openqa.selenium.html5.WebStorage;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.html5.RemoteWebStorage;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.service.DriverCommandExecutor;
import org.openqa.selenium.remote.service.DriverService;

public class FirefoxDriver
extends RemoteWebDriver
implements WebStorage,
HasExtensions {
    public static final String BINARY = "firefox_binary";
    public static final String PROFILE = "firefox_profile";
    public static final String MARIONETTE = "marionette";
    private static final ImmutableMap<String, CommandInfo> EXTRA_COMMANDS = ImmutableMap.of((Object)ExtraCommands.INSTALL_EXTENSION, (Object)new CommandInfo("/session/:sessionId/moz/addon/install", HttpMethod.POST), (Object)ExtraCommands.UNINSTALL_EXTENSION, (Object)new CommandInfo("/session/:sessionId/moz/addon/uninstall", HttpMethod.POST), (Object)ExtraCommands.FULL_PAGE_SCREENSHOT, (Object)new CommandInfo("/session/:sessionId/moz/screenshot/full", HttpMethod.GET));
    protected FirefoxBinary binary;
    private RemoteWebStorage webStorage = new RemoteWebStorage(this.getExecuteMethod());

    public FirefoxDriver() {
        this(new FirefoxOptions());
    }

    @Deprecated
    public FirefoxDriver(Capabilities desiredCapabilities) {
        this(new FirefoxOptions(Objects.requireNonNull(desiredCapabilities, "No capabilities seen")));
    }

    @Deprecated
    public FirefoxDriver(FirefoxDriverService service, Capabilities desiredCapabilities) {
        this(Objects.requireNonNull(service, "No driver service provided"), new FirefoxOptions(desiredCapabilities));
    }

    public FirefoxDriver(FirefoxOptions options) {
        super(FirefoxDriver.toExecutor(options), FirefoxDriver.dropCapabilities((Capabilities)options));
    }

    public FirefoxDriver(FirefoxDriverService service) {
        this(service, new FirefoxOptions());
    }

    public FirefoxDriver(FirefoxDriverService service, FirefoxOptions options) {
        super((CommandExecutor)new FirefoxDriverCommandExecutor(service), FirefoxDriver.dropCapabilities((Capabilities)options));
    }

    private static CommandExecutor toExecutor(FirefoxOptions options) {
        Objects.requireNonNull(options, "No options to construct executor from");
        String sysProperty = System.getProperty("webdriver.firefox.marionette");
        boolean isLegacy = sysProperty != null && !Boolean.parseBoolean(sysProperty) || options.isLegacy();
        FirefoxDriverService.Builder builder = StreamSupport.stream(ServiceLoader.load(DriverService.Builder.class).spliterator(), false).filter(b -> b instanceof FirefoxDriverService.Builder).map(b -> (FirefoxDriverService.Builder)((Object)b)).filter(b -> b.isLegacy() == isLegacy).findFirst().orElseThrow(WebDriverException::new);
        return new FirefoxDriverCommandExecutor(builder.withOptions(options).build());
    }

    public void setFileDetector(FileDetector detector) {
        throw new WebDriverException("Setting the file detector only works on remote webdriver instances obtained via RemoteWebDriver");
    }

    public LocalStorage getLocalStorage() {
        return this.webStorage.getLocalStorage();
    }

    public SessionStorage getSessionStorage() {
        return this.webStorage.getSessionStorage();
    }

    private static boolean isLegacy(Capabilities desiredCapabilities) {
        Boolean forceMarionette = FirefoxDriver.forceMarionetteFromSystemProperty();
        if (forceMarionette != null) {
            return forceMarionette == false;
        }
        Object marionette = desiredCapabilities.getCapability(MARIONETTE);
        return marionette instanceof Boolean && (Boolean)marionette == false;
    }

    @Override
    public String installExtension(Path path) {
        return (String)this.execute(ExtraCommands.INSTALL_EXTENSION, (Map)ImmutableMap.of((Object)"path", (Object)path.toAbsolutePath().toString(), (Object)"temporary", (Object)false)).getValue();
    }

    @Override
    public void uninstallExtension(String extensionId) {
        this.execute(ExtraCommands.UNINSTALL_EXTENSION, Collections.singletonMap("id", extensionId));
    }

    public <X> X getFullPageScreenshotAs(OutputType<X> outputType) throws WebDriverException {
        Response response = this.execute(ExtraCommands.FULL_PAGE_SCREENSHOT);
        Object result = response.getValue();
        if (result instanceof String) {
            String base64EncodedPng = (String)result;
            return (X)outputType.convertFromBase64Png(base64EncodedPng);
        }
        if (result instanceof byte[]) {
            String base64EncodedPng = new String((byte[])result);
            return (X)outputType.convertFromBase64Png(base64EncodedPng);
        }
        throw new RuntimeException(String.format("Unexpected result for %s command: %s", ExtraCommands.FULL_PAGE_SCREENSHOT, result == null ? "null" : result.getClass().getName() + " instance"));
    }

    private static Boolean forceMarionetteFromSystemProperty() {
        String useMarionette = System.getProperty("webdriver.firefox.marionette");
        if (useMarionette == null) {
            return null;
        }
        return Boolean.valueOf(useMarionette);
    }

    private static Capabilities dropCapabilities(Capabilities capabilities) {
        MutableCapabilities caps;
        if (capabilities == null) {
            return new ImmutableCapabilities();
        }
        if (FirefoxDriver.isLegacy(capabilities)) {
            HashSet toRemove = Sets.newHashSet((Object[])new String[]{BINARY, PROFILE});
            caps = new MutableCapabilities(Maps.filterKeys((Map)capabilities.asMap(), key -> !toRemove.contains(key)));
        } else {
            caps = new MutableCapabilities(capabilities);
        }
        Proxy proxy = Proxy.extractFrom((Capabilities)capabilities);
        if (proxy != null) {
            caps.setCapability("proxy", (Object)proxy);
        }
        return caps;
    }

    private static class FirefoxDriverCommandExecutor
    extends DriverCommandExecutor {
        public FirefoxDriverCommandExecutor(DriverService service) {
            super(service, (Map)EXTRA_COMMANDS);
        }
    }

    private static class ExtraCommands {
        static String INSTALL_EXTENSION = "installExtension";
        static String UNINSTALL_EXTENSION = "uninstallExtension";
        static String FULL_PAGE_SCREENSHOT = "fullPageScreenshot";

        private ExtraCommands() {
        }
    }

    public static final class SystemProperty {
        public static final String BROWSER_BINARY = "webdriver.firefox.bin";
        public static final String BROWSER_LOGFILE = "webdriver.firefox.logfile";
        public static final String BROWSER_LIBRARY_PATH = "webdriver.firefox.library.path";
        public static final String BROWSER_PROFILE = "webdriver.firefox.profile";
        public static final String DRIVER_XPI_PROPERTY = "webdriver.firefox.driver";
        public static final String DRIVER_USE_MARIONETTE = "webdriver.firefox.marionette";
    }
}

