/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.edge;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.edge.EdgeDriverService;

public class ChromiumEdgeDriverService
extends EdgeDriverService {
    public static final String EDGE_DRIVER_SILENT_OUTPUT_PROPERTY = "webdriver.edge.silentOutput";
    public static final String EDGE_DRIVER_ALLOWED_IPS_PROPERTY = "webdriver.edge.withAllowedIps";

    public ChromiumEdgeDriverService(File executable, int port, List<String> args, Map<String, String> environment) throws IOException {
        super(executable, port, DEFAULT_TIMEOUT, args, environment);
    }

    public ChromiumEdgeDriverService(File executable, int port, Duration timeout, List<String> args, Map<String, String> environment) throws IOException {
        super(executable, port, timeout, args, environment);
    }

    public static ChromiumEdgeDriverService createDefaultService() {
        return (ChromiumEdgeDriverService)new Builder().build();
    }

    public static class Builder
    extends EdgeDriverService.Builder<ChromiumEdgeDriverService, Builder> {
        private boolean verbose = Boolean.getBoolean("webdriver.edge.verboseLogging");
        private boolean silent = Boolean.getBoolean("webdriver.edge.silentOutput");
        private String allowedListIps = System.getProperty("webdriver.edge.withAllowedIps");

        @Override
        public boolean isLegacy() {
            return false;
        }

        public int score(Capabilities capabilities) {
            int score = 0;
            if ("MicrosoftEdge".equals(capabilities.getBrowserName())) {
                ++score;
            }
            if (capabilities.getCapability("ms:edgeOptions") != null) {
                ++score;
            }
            return score;
        }

        @Override
        public EdgeDriverService.Builder withVerbose(boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public Builder withSilent(boolean silent) {
            this.silent = silent;
            return this;
        }

        public Builder withAllowedListIps(String allowedListIps) {
            this.allowedListIps = allowedListIps;
            return this;
        }

        protected File findDefaultExecutable() {
            return ChromiumEdgeDriverService.findExecutable((String)"msedgedriver", (String)"webdriver.edge.driver", (String)"https://github.com/SeleniumHQ/selenium/wiki/MicrosoftWebDriver", (String)"https://msedgecdn.azurewebsites.net/webdriver/index.html");
        }

        protected ImmutableList<String> createArgs() {
            String logFilePath;
            if (this.getLogFile() == null && (logFilePath = System.getProperty("webdriver.edge.logfile")) != null) {
                this.withLogFile(new File(logFilePath));
            }
            ImmutableList.Builder argsBuilder = ImmutableList.builder();
            argsBuilder.add((Object)String.format("--port=%d", this.getPort()));
            if (this.getLogFile() != null) {
                argsBuilder.add((Object)String.format("--log-path=%s", this.getLogFile().getAbsolutePath()));
            }
            if (this.verbose) {
                argsBuilder.add((Object)"--verbose");
            }
            if (this.silent) {
                argsBuilder.add((Object)"--silent");
            }
            if (this.allowedListIps != null) {
                argsBuilder.add((Object)String.format("--whitelisted-ips=%s", this.allowedListIps));
            }
            return argsBuilder.build();
        }

        protected ChromiumEdgeDriverService createDriverService(File exe, int port, Duration timeout, ImmutableList<String> args, ImmutableMap<String, String> environment) {
            try {
                return new ChromiumEdgeDriverService(exe, port, timeout, (List<String>)args, (Map<String, String>)environment);
            }
            catch (IOException e) {
                throw new WebDriverException((Throwable)e);
            }
        }
    }
}

