/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.overlay.model;

import org.openqa.selenium.devtools.dom.model.RGBA;
import org.openqa.selenium.json.JsonInput;

public class HighlightConfig {
    private final Boolean showInfo;
    private final Boolean showStyles;
    private final Boolean showRulers;
    private final Boolean showExtensionLines;
    private final RGBA contentColor;
    private final RGBA paddingColor;
    private final RGBA borderColor;
    private final RGBA marginColor;
    private final RGBA eventTargetColor;
    private final RGBA shapeColor;
    private final RGBA shapeMarginColor;
    private final RGBA cssGridColor;

    public HighlightConfig(Boolean showInfo, Boolean showStyles, Boolean showRulers, Boolean showExtensionLines, RGBA contentColor, RGBA paddingColor, RGBA borderColor, RGBA marginColor, RGBA eventTargetColor, RGBA shapeColor, RGBA shapeMarginColor, RGBA cssGridColor) {
        this.showInfo = showInfo;
        this.showStyles = showStyles;
        this.showRulers = showRulers;
        this.showExtensionLines = showExtensionLines;
        this.contentColor = contentColor;
        this.paddingColor = paddingColor;
        this.borderColor = borderColor;
        this.marginColor = marginColor;
        this.eventTargetColor = eventTargetColor;
        this.shapeColor = shapeColor;
        this.shapeMarginColor = shapeMarginColor;
        this.cssGridColor = cssGridColor;
    }

    public Boolean getShowInfo() {
        return this.showInfo;
    }

    public Boolean getShowStyles() {
        return this.showStyles;
    }

    public Boolean getShowRulers() {
        return this.showRulers;
    }

    public Boolean getShowExtensionLines() {
        return this.showExtensionLines;
    }

    public RGBA getContentColor() {
        return this.contentColor;
    }

    public RGBA getPaddingColor() {
        return this.paddingColor;
    }

    public RGBA getBorderColor() {
        return this.borderColor;
    }

    public RGBA getMarginColor() {
        return this.marginColor;
    }

    public RGBA getEventTargetColor() {
        return this.eventTargetColor;
    }

    public RGBA getShapeColor() {
        return this.shapeColor;
    }

    public RGBA getShapeMarginColor() {
        return this.shapeMarginColor;
    }

    public RGBA getCssGridColor() {
        return this.cssGridColor;
    }

    private static HighlightConfig fromJson(JsonInput input) {
        Boolean showInfo = null;
        Boolean showStyles = null;
        Boolean showRulers = null;
        Boolean showExtensionLines = null;
        RGBA contentColor = null;
        RGBA paddingColor = null;
        RGBA borderColor = null;
        RGBA marginColor = null;
        RGBA eventTargetColor = null;
        RGBA shapeColor = null;
        RGBA shapeMarginColor = null;
        RGBA cssGridColor = null;
        input.beginObject();
        block28: while (input.hasNext()) {
            switch (input.nextName()) {
                case "showInfo": {
                    showInfo = input.nextBoolean();
                    continue block28;
                }
                case "showStyles": {
                    showStyles = input.nextBoolean();
                    continue block28;
                }
                case "showRulers": {
                    showRulers = input.nextBoolean();
                    continue block28;
                }
                case "showExtensionLines": {
                    showExtensionLines = input.nextBoolean();
                    continue block28;
                }
                case "contentColor": {
                    contentColor = (RGBA)input.read(RGBA.class);
                    continue block28;
                }
                case "paddingColor": {
                    paddingColor = (RGBA)input.read(RGBA.class);
                    continue block28;
                }
                case "borderColor": {
                    borderColor = (RGBA)input.read(RGBA.class);
                    continue block28;
                }
                case "marginColor": {
                    marginColor = (RGBA)input.read(RGBA.class);
                    continue block28;
                }
                case "eventTargetColor": {
                    eventTargetColor = (RGBA)input.read(RGBA.class);
                    continue block28;
                }
                case "shapeColor": {
                    shapeColor = (RGBA)input.read(RGBA.class);
                    continue block28;
                }
                case "shapeMarginColor": {
                    shapeMarginColor = (RGBA)input.read(RGBA.class);
                    continue block28;
                }
                case "cssGridColor": {
                    cssGridColor = (RGBA)input.read(RGBA.class);
                    continue block28;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new HighlightConfig(showInfo, showStyles, showRulers, showExtensionLines, contentColor, paddingColor, borderColor, marginColor, eventTargetColor, shapeColor, shapeMarginColor, cssGridColor);
    }
}

