/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.indexeddb.model;

import java.util.Objects;
import org.openqa.selenium.devtools.indexeddb.model.Key;
import org.openqa.selenium.json.JsonInput;

public class KeyRange {
    private final Key lower;
    private final Key upper;
    private final Boolean lowerOpen;
    private final Boolean upperOpen;

    public KeyRange(Key lower, Key upper, Boolean lowerOpen, Boolean upperOpen) {
        this.lower = lower;
        this.upper = upper;
        this.lowerOpen = Objects.requireNonNull(lowerOpen, "lowerOpen is required");
        this.upperOpen = Objects.requireNonNull(upperOpen, "upperOpen is required");
    }

    public Key getLower() {
        return this.lower;
    }

    public Key getUpper() {
        return this.upper;
    }

    public Boolean getLowerOpen() {
        return this.lowerOpen;
    }

    public Boolean getUpperOpen() {
        return this.upperOpen;
    }

    private static KeyRange fromJson(JsonInput input) {
        Key lower = null;
        Key upper = null;
        Boolean lowerOpen = null;
        Boolean upperOpen = null;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "lower": {
                    lower = (Key)input.read(Key.class);
                    continue block12;
                }
                case "upper": {
                    upper = (Key)input.read(Key.class);
                    continue block12;
                }
                case "lowerOpen": {
                    lowerOpen = input.nextBoolean();
                    continue block12;
                }
                case "upperOpen": {
                    upperOpen = input.nextBoolean();
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new KeyRange(lower, upper, lowerOpen, upperOpen);
    }
}

