/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.css.model;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.devtools.css.model.CSSProperty;
import org.openqa.selenium.devtools.css.model.ShorthandEntry;
import org.openqa.selenium.devtools.css.model.SourceRange;
import org.openqa.selenium.devtools.css.model.StyleSheetId;
import org.openqa.selenium.json.JsonInput;

public class CSSStyle {
    private final StyleSheetId styleSheetId;
    private final List<CSSProperty> cssProperties;
    private final List<ShorthandEntry> shorthandEntries;
    private final String cssText;
    private final SourceRange range;

    public CSSStyle(StyleSheetId styleSheetId, List<CSSProperty> cssProperties, List<ShorthandEntry> shorthandEntries, String cssText, SourceRange range) {
        this.styleSheetId = styleSheetId;
        this.cssProperties = Objects.requireNonNull(cssProperties, "cssProperties is required");
        this.shorthandEntries = Objects.requireNonNull(shorthandEntries, "shorthandEntries is required");
        this.cssText = cssText;
        this.range = range;
    }

    public StyleSheetId getStyleSheetId() {
        return this.styleSheetId;
    }

    public List<CSSProperty> getCssProperties() {
        return this.cssProperties;
    }

    public List<ShorthandEntry> getShorthandEntries() {
        return this.shorthandEntries;
    }

    public String getCssText() {
        return this.cssText;
    }

    public SourceRange getRange() {
        return this.range;
    }

    private static CSSStyle fromJson(JsonInput input) {
        StyleSheetId styleSheetId = null;
        List cssProperties = null;
        List shorthandEntries = null;
        String cssText = null;
        SourceRange range = null;
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "styleSheetId": {
                    styleSheetId = (StyleSheetId)input.read(StyleSheetId.class);
                    continue block14;
                }
                case "cssProperties": {
                    cssProperties = (List)input.read(new TypeToken<List<CSSProperty>>(){}.getType());
                    continue block14;
                }
                case "shorthandEntries": {
                    shorthandEntries = (List)input.read(new TypeToken<List<ShorthandEntry>>(){}.getType());
                    continue block14;
                }
                case "cssText": {
                    cssText = input.nextString();
                    continue block14;
                }
                case "range": {
                    range = (SourceRange)input.read(SourceRange.class);
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new CSSStyle(styleSheetId, cssProperties, shorthandEntries, cssText, range);
    }
}

