/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import java.io.Closeable;
import java.io.Reader;
import java.io.StringReader;
import java.time.Duration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.target.model.SessionID;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.WebSocket;

public class Connection
implements Closeable {
    private static final Logger LOG = Logger.getLogger(Connection.class.getName());
    private static final Json JSON = new Json();
    private static final AtomicLong NEXT_ID = new AtomicLong(1L);
    private final WebSocket socket;
    private final Map<Long, Consumer<JsonInput>> methodCallbacks = new LinkedHashMap<Long, Consumer<JsonInput>>();
    private final Multimap<Event<?>, Consumer<?>> eventCallbacks = HashMultimap.create();

    public Connection(HttpClient client, String url) {
        Objects.requireNonNull(client, "HTTP client must be set.");
        Objects.requireNonNull(url, "URL to connect to must be set.");
        this.socket = client.openSocket(new HttpRequest(HttpMethod.GET, url), (WebSocket.Listener)new Listener());
    }

    public <X> CompletableFuture<X> send(SessionID sessionId, Command<X> command) {
        long id = NEXT_ID.getAndIncrement();
        CompletableFuture<Object> result = new CompletableFuture<Object>();
        if (command.getSendsResponse()) {
            this.methodCallbacks.put(id, input -> {
                Object value = command.getMapper().apply((JsonInput)input);
                result.complete(value);
            });
        }
        ImmutableMap.Builder serialized = ImmutableMap.builder();
        serialized.put((Object)"id", (Object)id);
        serialized.put((Object)"method", (Object)command.getMethod());
        serialized.put((Object)"params", command.getParams());
        if (sessionId != null) {
            serialized.put((Object)"sessionId", (Object)sessionId);
        }
        LOG.info(JSON.toJson((Object)serialized.build()));
        this.socket.sendText((CharSequence)JSON.toJson((Object)serialized.build()));
        if (!command.getSendsResponse()) {
            result.complete(null);
        }
        return result;
    }

    public <X> X sendAndWait(SessionID sessionId, Command<X> command, Duration timeout) {
        try {
            return this.send(sessionId, command).get(timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Thread has been interrupted", e);
        }
        catch (ExecutionException e) {
            Throwable cause = e;
            if (e.getCause() != null) {
                cause = e.getCause();
            }
            throw new DevToolsException(cause);
        }
        catch (java.util.concurrent.TimeoutException e) {
            throw new TimeoutException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <X> void addListener(Event<X> event, Consumer<X> handler) {
        Objects.requireNonNull(event);
        Objects.requireNonNull(handler);
        Multimap<Event<?>, Consumer<?>> multimap = this.eventCallbacks;
        synchronized (multimap) {
            this.eventCallbacks.put(event, handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearListeners() {
        Multimap<Event<?>, Consumer<?>> multimap = this.eventCallbacks;
        synchronized (multimap) {
            this.eventCallbacks.clear();
        }
    }

    @Override
    public void close() {
        this.socket.close();
    }

    private class Listener
    extends WebSocket.Listener {
        private Listener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onText(CharSequence data) {
            block25: {
                String asString = String.valueOf(data);
                LOG.info(asString);
                Map raw = (Map)JSON.toType(asString, Json.MAP_TYPE);
                if (raw.get("id") instanceof Number && raw.get("result") != null) {
                    Consumer consumer = (Consumer)Connection.this.methodCallbacks.remove(((Number)raw.get("id")).longValue());
                    if (consumer == null) {
                        return;
                    }
                    try (StringReader reader = new StringReader(asString);
                         JsonInput input = JSON.newInput((Reader)reader);){
                        input.beginObject();
                        block19: while (input.hasNext()) {
                            switch (input.nextName()) {
                                case "result": {
                                    consumer.accept(input);
                                    continue block19;
                                }
                            }
                            input.skipValue();
                        }
                        input.endObject();
                        break block25;
                    }
                }
                if (raw.get("method") instanceof String && raw.get("params") instanceof Map) {
                    LOG.fine("Seen: " + raw);
                    Multimap multimap = Connection.this.eventCallbacks;
                    synchronized (multimap) {
                        Connection.this.eventCallbacks.keySet().stream().filter(event -> raw.get("method").equals(event.getMethod())).forEach(event -> {
                            try (StringReader reader = new StringReader(asString);
                                 JsonInput input = JSON.newInput((Reader)reader);){
                                Object value = null;
                                input.beginObject();
                                block18: while (input.hasNext()) {
                                    switch (input.nextName()) {
                                        case "params": {
                                            value = event.getMapper().apply(input);
                                            continue block18;
                                        }
                                    }
                                    input.skipValue();
                                }
                                input.endObject();
                                if (value == null) {
                                    return;
                                }
                                Object finalValue = value;
                                Iterator iterator = Connection.this.eventCallbacks.get(event).iterator();
                                while (iterator.hasNext()) {
                                    Consumer action;
                                    Consumer obj = action = (Consumer)iterator.next();
                                    obj.accept(finalValue);
                                }
                            }
                        });
                    }
                } else {
                    LOG.warning("Unhandled type: " + data);
                }
            }
        }
    }
}

