/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v94.audits.model;

import java.util.Arrays;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public enum InspectorIssueCode {
    SAMESITECOOKIEISSUE("SameSiteCookieIssue"),
    MIXEDCONTENTISSUE("MixedContentIssue"),
    BLOCKEDBYRESPONSEISSUE("BlockedByResponseIssue"),
    HEAVYADISSUE("HeavyAdIssue"),
    CONTENTSECURITYPOLICYISSUE("ContentSecurityPolicyIssue"),
    SHAREDARRAYBUFFERISSUE("SharedArrayBufferIssue"),
    TRUSTEDWEBACTIVITYISSUE("TrustedWebActivityIssue"),
    LOWTEXTCONTRASTISSUE("LowTextContrastIssue"),
    CORSISSUE("CorsIssue"),
    ATTRIBUTIONREPORTINGISSUE("AttributionReportingIssue"),
    QUIRKSMODEISSUE("QuirksModeIssue"),
    NAVIGATORUSERAGENTISSUE("NavigatorUserAgentIssue"),
    WASMCROSSORIGINMODULESHARINGISSUE("WasmCrossOriginModuleSharingIssue");

    private String value;

    private InspectorIssueCode(String value) {
        this.value = value;
    }

    public static InspectorIssueCode fromString(String s) {
        return Arrays.stream(InspectorIssueCode.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within InspectorIssueCode "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static InspectorIssueCode fromJson(JsonInput input) {
        return InspectorIssueCode.fromString(input.nextString());
    }
}

