package org.openqa.selenium.devtools.v94.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * HTTP response data.
 */
public class Response {

    private final java.lang.String url;

    private final java.lang.Integer status;

    private final java.lang.String statusText;

    private final org.openqa.selenium.devtools.v94.network.model.Headers headers;

    private final java.util.Optional<java.lang.String> headersText;

    private final java.lang.String mimeType;

    private final java.util.Optional<org.openqa.selenium.devtools.v94.network.model.Headers> requestHeaders;

    private final java.util.Optional<java.lang.String> requestHeadersText;

    private final java.lang.Boolean connectionReused;

    private final java.lang.Number connectionId;

    private final java.util.Optional<java.lang.String> remoteIPAddress;

    private final java.util.Optional<java.lang.Integer> remotePort;

    private final java.util.Optional<java.lang.Boolean> fromDiskCache;

    private final java.util.Optional<java.lang.Boolean> fromServiceWorker;

    private final java.util.Optional<java.lang.Boolean> fromPrefetchCache;

    private final java.lang.Number encodedDataLength;

    private final java.util.Optional<org.openqa.selenium.devtools.v94.network.model.ResourceTiming> timing;

    private final java.util.Optional<org.openqa.selenium.devtools.v94.network.model.ServiceWorkerResponseSource> serviceWorkerResponseSource;

    private final java.util.Optional<org.openqa.selenium.devtools.v94.network.model.TimeSinceEpoch> responseTime;

    private final java.util.Optional<java.lang.String> cacheStorageCacheName;

    private final java.util.Optional<java.lang.String> protocol;

    private final org.openqa.selenium.devtools.v94.security.model.SecurityState securityState;

    private final java.util.Optional<org.openqa.selenium.devtools.v94.network.model.SecurityDetails> securityDetails;

    public Response(java.lang.String url, java.lang.Integer status, java.lang.String statusText, org.openqa.selenium.devtools.v94.network.model.Headers headers, java.util.Optional<java.lang.String> headersText, java.lang.String mimeType, java.util.Optional<org.openqa.selenium.devtools.v94.network.model.Headers> requestHeaders, java.util.Optional<java.lang.String> requestHeadersText, java.lang.Boolean connectionReused, java.lang.Number connectionId, java.util.Optional<java.lang.String> remoteIPAddress, java.util.Optional<java.lang.Integer> remotePort, java.util.Optional<java.lang.Boolean> fromDiskCache, java.util.Optional<java.lang.Boolean> fromServiceWorker, java.util.Optional<java.lang.Boolean> fromPrefetchCache, java.lang.Number encodedDataLength, java.util.Optional<org.openqa.selenium.devtools.v94.network.model.ResourceTiming> timing, java.util.Optional<org.openqa.selenium.devtools.v94.network.model.ServiceWorkerResponseSource> serviceWorkerResponseSource, java.util.Optional<org.openqa.selenium.devtools.v94.network.model.TimeSinceEpoch> responseTime, java.util.Optional<java.lang.String> cacheStorageCacheName, java.util.Optional<java.lang.String> protocol, org.openqa.selenium.devtools.v94.security.model.SecurityState securityState, java.util.Optional<org.openqa.selenium.devtools.v94.network.model.SecurityDetails> securityDetails) {
        this.url = java.util.Objects.requireNonNull(url, "url is required");
        this.status = java.util.Objects.requireNonNull(status, "status is required");
        this.statusText = java.util.Objects.requireNonNull(statusText, "statusText is required");
        this.headers = java.util.Objects.requireNonNull(headers, "headers is required");
        this.headersText = headersText;
        this.mimeType = java.util.Objects.requireNonNull(mimeType, "mimeType is required");
        this.requestHeaders = requestHeaders;
        this.requestHeadersText = requestHeadersText;
        this.connectionReused = java.util.Objects.requireNonNull(connectionReused, "connectionReused is required");
        this.connectionId = java.util.Objects.requireNonNull(connectionId, "connectionId is required");
        this.remoteIPAddress = remoteIPAddress;
        this.remotePort = remotePort;
        this.fromDiskCache = fromDiskCache;
        this.fromServiceWorker = fromServiceWorker;
        this.fromPrefetchCache = fromPrefetchCache;
        this.encodedDataLength = java.util.Objects.requireNonNull(encodedDataLength, "encodedDataLength is required");
        this.timing = timing;
        this.serviceWorkerResponseSource = serviceWorkerResponseSource;
        this.responseTime = responseTime;
        this.cacheStorageCacheName = cacheStorageCacheName;
        this.protocol = protocol;
        this.securityState = java.util.Objects.requireNonNull(securityState, "securityState is required");
        this.securityDetails = securityDetails;
    }

    /**
     * Response URL. This URL can be different from CachedResource.url in case of redirect.
     */
    public java.lang.String getUrl() {
        return url;
    }

    /**
     * HTTP response status code.
     */
    public java.lang.Integer getStatus() {
        return status;
    }

    /**
     * HTTP response status text.
     */
    public java.lang.String getStatusText() {
        return statusText;
    }

    /**
     * HTTP response headers.
     */
    public org.openqa.selenium.devtools.v94.network.model.Headers getHeaders() {
        return headers;
    }

    /**
     * HTTP response headers text. This has been replaced by the headers in Network.responseReceivedExtraInfo.
     */
    @Deprecated()
    public java.util.Optional<java.lang.String> getHeadersText() {
        return headersText;
    }

    /**
     * Resource mimeType as determined by the browser.
     */
    public java.lang.String getMimeType() {
        return mimeType;
    }

    /**
     * Refined HTTP request headers that were actually transmitted over the network.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v94.network.model.Headers> getRequestHeaders() {
        return requestHeaders;
    }

    /**
     * HTTP request headers text. This has been replaced by the headers in Network.requestWillBeSentExtraInfo.
     */
    @Deprecated()
    public java.util.Optional<java.lang.String> getRequestHeadersText() {
        return requestHeadersText;
    }

    /**
     * Specifies whether physical connection was actually reused for this request.
     */
    public java.lang.Boolean getConnectionReused() {
        return connectionReused;
    }

    /**
     * Physical connection id that was actually used for this request.
     */
    public java.lang.Number getConnectionId() {
        return connectionId;
    }

    /**
     * Remote IP address.
     */
    public java.util.Optional<java.lang.String> getRemoteIPAddress() {
        return remoteIPAddress;
    }

    /**
     * Remote port.
     */
    public java.util.Optional<java.lang.Integer> getRemotePort() {
        return remotePort;
    }

    /**
     * Specifies that the request was served from the disk cache.
     */
    public java.util.Optional<java.lang.Boolean> getFromDiskCache() {
        return fromDiskCache;
    }

    /**
     * Specifies that the request was served from the ServiceWorker.
     */
    public java.util.Optional<java.lang.Boolean> getFromServiceWorker() {
        return fromServiceWorker;
    }

    /**
     * Specifies that the request was served from the prefetch cache.
     */
    public java.util.Optional<java.lang.Boolean> getFromPrefetchCache() {
        return fromPrefetchCache;
    }

    /**
     * Total number of bytes received for this request so far.
     */
    public java.lang.Number getEncodedDataLength() {
        return encodedDataLength;
    }

    /**
     * Timing information for the given request.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v94.network.model.ResourceTiming> getTiming() {
        return timing;
    }

    /**
     * Response source of response from ServiceWorker.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v94.network.model.ServiceWorkerResponseSource> getServiceWorkerResponseSource() {
        return serviceWorkerResponseSource;
    }

    /**
     * The time at which the returned response was generated.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v94.network.model.TimeSinceEpoch> getResponseTime() {
        return responseTime;
    }

    /**
     * Cache Storage Cache Name.
     */
    public java.util.Optional<java.lang.String> getCacheStorageCacheName() {
        return cacheStorageCacheName;
    }

    /**
     * Protocol used to fetch this request.
     */
    public java.util.Optional<java.lang.String> getProtocol() {
        return protocol;
    }

    /**
     * Security state of the request resource.
     */
    public org.openqa.selenium.devtools.v94.security.model.SecurityState getSecurityState() {
        return securityState;
    }

    /**
     * Security details for the request.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v94.network.model.SecurityDetails> getSecurityDetails() {
        return securityDetails;
    }

    private static Response fromJson(JsonInput input) {
        java.lang.String url = null;
        java.lang.Integer status = 0;
        java.lang.String statusText = null;
        org.openqa.selenium.devtools.v94.network.model.Headers headers = null;
        java.util.Optional<java.lang.String> headersText = java.util.Optional.empty();
        java.lang.String mimeType = null;
        java.util.Optional<org.openqa.selenium.devtools.v94.network.model.Headers> requestHeaders = java.util.Optional.empty();
        java.util.Optional<java.lang.String> requestHeadersText = java.util.Optional.empty();
        java.lang.Boolean connectionReused = false;
        java.lang.Number connectionId = 0;
        java.util.Optional<java.lang.String> remoteIPAddress = java.util.Optional.empty();
        java.util.Optional<java.lang.Integer> remotePort = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> fromDiskCache = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> fromServiceWorker = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> fromPrefetchCache = java.util.Optional.empty();
        java.lang.Number encodedDataLength = 0;
        java.util.Optional<org.openqa.selenium.devtools.v94.network.model.ResourceTiming> timing = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v94.network.model.ServiceWorkerResponseSource> serviceWorkerResponseSource = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v94.network.model.TimeSinceEpoch> responseTime = java.util.Optional.empty();
        java.util.Optional<java.lang.String> cacheStorageCacheName = java.util.Optional.empty();
        java.util.Optional<java.lang.String> protocol = java.util.Optional.empty();
        org.openqa.selenium.devtools.v94.security.model.SecurityState securityState = null;
        java.util.Optional<org.openqa.selenium.devtools.v94.network.model.SecurityDetails> securityDetails = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "url":
                    url = input.nextString();
                    break;
                case "status":
                    status = input.nextNumber().intValue();
                    break;
                case "statusText":
                    statusText = input.nextString();
                    break;
                case "headers":
                    headers = input.read(org.openqa.selenium.devtools.v94.network.model.Headers.class);
                    break;
                case "headersText":
                    headersText = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "mimeType":
                    mimeType = input.nextString();
                    break;
                case "requestHeaders":
                    requestHeaders = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v94.network.model.Headers.class));
                    break;
                case "requestHeadersText":
                    requestHeadersText = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "connectionReused":
                    connectionReused = input.nextBoolean();
                    break;
                case "connectionId":
                    connectionId = input.nextNumber();
                    break;
                case "remoteIPAddress":
                    remoteIPAddress = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "remotePort":
                    remotePort = java.util.Optional.ofNullable(input.nextNumber().intValue());
                    break;
                case "fromDiskCache":
                    fromDiskCache = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "fromServiceWorker":
                    fromServiceWorker = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "fromPrefetchCache":
                    fromPrefetchCache = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "encodedDataLength":
                    encodedDataLength = input.nextNumber();
                    break;
                case "timing":
                    timing = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v94.network.model.ResourceTiming.class));
                    break;
                case "serviceWorkerResponseSource":
                    serviceWorkerResponseSource = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v94.network.model.ServiceWorkerResponseSource.class));
                    break;
                case "responseTime":
                    responseTime = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v94.network.model.TimeSinceEpoch.class));
                    break;
                case "cacheStorageCacheName":
                    cacheStorageCacheName = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "protocol":
                    protocol = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "securityState":
                    securityState = input.read(org.openqa.selenium.devtools.v94.security.model.SecurityState.class);
                    break;
                case "securityDetails":
                    securityDetails = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v94.network.model.SecurityDetails.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new Response(url, status, statusText, headers, headersText, mimeType, requestHeaders, requestHeadersText, connectionReused, connectionId, remoteIPAddress, remotePort, fromDiskCache, fromServiceWorker, fromPrefetchCache, encodedDataLength, timing, serviceWorkerResponseSource, responseTime, cacheStorageCacheName, protocol, securityState, securityDetails);
    }
}
