/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v93.page.model;

import java.util.Arrays;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.v93.dom.model.BackendNodeId;
import org.openqa.selenium.devtools.v93.page.model.FrameId;
import org.openqa.selenium.json.JsonInput;

public class FileChooserOpened {
    private final FrameId frameId;
    private final BackendNodeId backendNodeId;
    private final Mode mode;

    public FileChooserOpened(FrameId frameId, BackendNodeId backendNodeId, Mode mode) {
        this.frameId = Objects.requireNonNull(frameId, "frameId is required");
        this.backendNodeId = Objects.requireNonNull(backendNodeId, "backendNodeId is required");
        this.mode = Objects.requireNonNull(mode, "mode is required");
    }

    @Beta
    public FrameId getFrameId() {
        return this.frameId;
    }

    @Beta
    public BackendNodeId getBackendNodeId() {
        return this.backendNodeId;
    }

    public Mode getMode() {
        return this.mode;
    }

    private static FileChooserOpened fromJson(JsonInput input) {
        FrameId frameId = null;
        BackendNodeId backendNodeId = null;
        Mode mode = null;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "frameId": {
                    frameId = (FrameId)input.read(FrameId.class);
                    continue block10;
                }
                case "backendNodeId": {
                    backendNodeId = (BackendNodeId)input.read(BackendNodeId.class);
                    continue block10;
                }
                case "mode": {
                    mode = Mode.fromString(input.nextString());
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new FileChooserOpened(frameId, backendNodeId, mode);
    }

    public static enum Mode {
        SELECTSINGLE("selectSingle"),
        SELECTMULTIPLE("selectMultiple");

        private String value;

        private Mode(String value) {
            this.value = value;
        }

        public static Mode fromString(String s) {
            return Arrays.stream(Mode.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within Mode "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static Mode fromJson(JsonInput input) {
            return Mode.fromString(input.nextString());
        }
    }
}

