/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v93.network.model;

import java.util.Objects;
import org.openqa.selenium.devtools.v93.network.model.MonotonicTime;
import org.openqa.selenium.devtools.v93.network.model.RequestId;
import org.openqa.selenium.json.JsonInput;

public class DataReceived {
    private final RequestId requestId;
    private final MonotonicTime timestamp;
    private final Integer dataLength;
    private final Integer encodedDataLength;

    public DataReceived(RequestId requestId, MonotonicTime timestamp, Integer dataLength, Integer encodedDataLength) {
        this.requestId = Objects.requireNonNull(requestId, "requestId is required");
        this.timestamp = Objects.requireNonNull(timestamp, "timestamp is required");
        this.dataLength = Objects.requireNonNull(dataLength, "dataLength is required");
        this.encodedDataLength = Objects.requireNonNull(encodedDataLength, "encodedDataLength is required");
    }

    public RequestId getRequestId() {
        return this.requestId;
    }

    public MonotonicTime getTimestamp() {
        return this.timestamp;
    }

    public Integer getDataLength() {
        return this.dataLength;
    }

    public Integer getEncodedDataLength() {
        return this.encodedDataLength;
    }

    private static DataReceived fromJson(JsonInput input) {
        RequestId requestId = null;
        MonotonicTime timestamp = null;
        Integer dataLength = 0;
        Integer encodedDataLength = 0;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "requestId": {
                    requestId = (RequestId)input.read(RequestId.class);
                    continue block12;
                }
                case "timestamp": {
                    timestamp = (MonotonicTime)input.read(MonotonicTime.class);
                    continue block12;
                }
                case "dataLength": {
                    dataLength = input.nextNumber().intValue();
                    continue block12;
                }
                case "encodedDataLength": {
                    encodedDataLength = input.nextNumber().intValue();
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new DataReceived(requestId, timestamp, dataLength, encodedDataLength);
    }
}

