/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v90.network.model;

import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@Beta
public class LoadNetworkResourceOptions {
    private final Boolean disableCache;
    private final Boolean includeCredentials;

    public LoadNetworkResourceOptions(Boolean disableCache, Boolean includeCredentials) {
        this.disableCache = Objects.requireNonNull(disableCache, "disableCache is required");
        this.includeCredentials = Objects.requireNonNull(includeCredentials, "includeCredentials is required");
    }

    public Boolean getDisableCache() {
        return this.disableCache;
    }

    public Boolean getIncludeCredentials() {
        return this.includeCredentials;
    }

    private static LoadNetworkResourceOptions fromJson(JsonInput input) {
        Boolean disableCache = false;
        Boolean includeCredentials = false;
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "disableCache": {
                    disableCache = input.nextBoolean();
                    continue block8;
                }
                case "includeCredentials": {
                    includeCredentials = input.nextBoolean();
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new LoadNetworkResourceOptions(disableCache, includeCredentials);
    }
}

